/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @license Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-licensing-options
 */
/**
 * @module style/ui/stylegroupview
 */
import { LabelView, View } from 'ckeditor5/src/ui.js';
import type { Locale } from 'ckeditor5/src/utils.js';
import StyleGridView from './stylegridview.js';
import type { NormalizedStyleDefinition } from '../styleutils.js';
import '../../theme/stylegroup.css';
/**
 * A class representing a group of styles (e.g. "block" or "inline").
 *
 * Renders a {@link module:style/ui/stylegridview~StyleGridView style grid} and a label.
 */
export default class StyleGroupView extends View<HTMLDivElement> {
    /**
     * The styles grid of the group.
     */
    readonly gridView: StyleGridView;
    /**
     * The label of the group.
     */
    readonly labelView: LabelView;
    /**
     * Creates an instance of the {@link module:style/ui/stylegroupview~StyleGroupView} class.
     *
     * @param locale The localization services instance.
     * @param label The localized label of the group.
     * @param styleDefinitions Definitions of the styles in the group.
     */
    constructor(locale: Locale, label: string, styleDefinitions: Array<NormalizedStyleDefinition>);
}
