<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once("../../globals.php");
include_once("$srcdir/api.inc");

// Current user
$current_user = $_SESSION['authUser'] ?? 'system';

// Get POST data
$admission_id = $_POST['admission_id'] ?? null;
$new_ward     = $_POST['new_ward'] ?? null;
$new_bed      = $_POST['new_bed'] ?? null;

if (!$admission_id || !$new_ward || !$new_bed) {
    die("⚠️ Missing required data.");
}

// Fetch current admission info
$res  = sqlStatement("SELECT * FROM form_admission WHERE id = ?", [$admission_id]);
$admission = sqlFetchArray($res);

if (!$admission) {
    die("⚠️ Admission record not found.");
}

// Save current date/time
$now = date('Y-m-d H:i:s');

// Update admission table
sqlStatement(
    "UPDATE form_admission SET ward = ?, bed = ? WHERE id = ?",
    [$new_ward, $new_bed, $admission_id]
);

// Insert into transfer log
sqlStatement(
    "INSERT INTO form_transfer_log
        (admission_id, old_ward, old_bed, new_ward, new_bed, transfer_date, user)
     VALUES (?, ?, ?, ?, ?, ?, ?)",
    [$admission_id, $admission['ward'], $admission['bed'], $new_ward, $new_bed, $now, $current_user]
);

// Insert into form_transfer table
sqlStatement(
    "INSERT INTO form_transfer
        (transfer_date, from_ward, from_bed, to_ward, to_bed, doctor, pid, encounter, user, groupname, authorized, activity)
     VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1, 1)",
    [$now, $admission['ward'], $admission['bed'], $new_ward, $new_bed, $current_user, $admission['pid'], $admission['encounter'], $current_user, 'Default']
);

// 🔑 Fetch the inserted transfer record ID using pid, transfer_date
$res = sqlStatement(
    "SELECT id FROM form_transfer WHERE pid = ? AND transfer_date = ? ORDER BY id DESC LIMIT 1",
    [$admission['pid'], $now]
);
$row = sqlFetchArray($res);
$transfer_id = $row['id'] ?? 0;

// Redirect to view page
if ($transfer_id) {
    formHeader("Redirecting...");
    formJump("$rootdir/forms/form_transfer/view.php?id=$transfer_id");
    formFooter();
} else {
    die("⚠️ Could not fetch the transfer record.");
}
?>
