<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");

$id = $_GET['id'] ?? null;
if (!$id) die("No form ID provided.");

// Fetch data
$row = sqlQuery("SELECT * FROM form_diet_orders WHERE id=?", array($id));
if (!$row) die("Form not found.");

// Build the correct edit URL
$edit_url = $GLOBALS['webroot'] . "/interface/forms/diet_orders/new.php?id=" . $id;
?>
<html>
<head>
    <title>View Diet Orders</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 20px;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h3 {
            color: #007BFF;
        }
        .button-group {
            margin-bottom: 20px;
        }
        a.edit-btn, a.back-btn {
            padding: 8px 12px;
            background: #007BFF;
            color: white;
            border-radius: 4px;
            text-decoration: none;
            display: inline-block;
            margin-right: 10px;
        }
        a.back-btn {
            background: #6c757d;
        }
        a.edit-btn:hover {
            background: #0056b3;
        }
        a.back-btn:hover {
            background: #5a6268;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #dee2e6;
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #007BFF;
            color: white;
        }
        .section {
            margin-bottom: 20px;
            padding: 15px;
            background: #ffffff;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .empty-value {
            color: #999;
            font-style: italic;
        }
    </style>
</head>
<body>
    <h3>Diet Orders - View</h3>

    <!-- Button Group -->
    <div class="button-group">
        <a class="edit-btn" href="<?php echo $edit_url; ?>" onclick="top.restoreSession()">
            <i class="fa fa-edit"></i> Edit
        </a>
        <a class="back-btn" href="javascript:void(0)" onclick="window.close();">
            <i class="fa fa-arrow-left"></i> Close
        </a>
    </div>

    <div class="section">
        <h4>Diet Information</h4>
        <table>
            <tr><th>Field</th><th>Value</th></tr>
            <tr><td>Diet Type 1</td><td><?php echo htmlspecialchars($row['diet_type1']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <?php if (!empty($row['diet_type1_other'])): ?>
            <tr><td>Diet Type 1 (Other)</td><td><?php echo htmlspecialchars($row['diet_type1_other']); ?></td></tr>
            <?php endif; ?>
            <tr><td>Diet Details</td><td><?php echo htmlspecialchars($row['diet_type2']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <?php if (!empty($row['diet_extra'])): ?>
            <tr><td>Diet Extra Details</td><td><?php echo htmlspecialchars($row['diet_extra']); ?></td></tr>
            <?php endif; ?>
            <tr><td>Texture Modification</td><td><?php echo htmlspecialchars($row['texture_mod']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <tr><td>Supplements</td><td><?php echo htmlspecialchars($row['supplements']) ?: '<span class="empty-value">None</span>'; ?></td></tr>
            <tr><td>Allergies</td><td><?php echo htmlspecialchars($row['allergies']) ?: '<span class="empty-value">None reported</span>'; ?></td></tr>
            <tr><td>Additional Instructions</td><td><?php echo $row['additional_instructions'] ? nl2br(htmlspecialchars($row['additional_instructions'])) : '<span class="empty-value">None</span>'; ?></td></tr>
        </table>
    </div>

    <div class="section">
        <h4>Tube Feeding Orders</h4>
        <table>
            <tr><th>Field</th><th>Value</th></tr>
            <tr><td>Feeding Route</td><td><?php echo htmlspecialchars($row['feeding_route']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <?php if (!empty($row['feeding_route_other'])): ?>
            <tr><td>Feeding Route (Other)</td><td><?php echo htmlspecialchars($row['feeding_route_other']); ?></td></tr>
            <?php endif; ?>
            <tr><td>Formula</td><td><?php echo htmlspecialchars($row['formula']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <?php if (!empty($row['formula_other'])): ?>
            <tr><td>Formula (Other)</td><td><?php echo htmlspecialchars($row['formula_other']); ?></td></tr>
            <?php endif; ?>
            <tr><td>Method of Administration</td><td><?php echo htmlspecialchars($row['method_admin']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <tr><td>Amount (ml)</td><td><?php echo htmlspecialchars($row['amount_ml']) ?: '<span class="empty-value">-</span>'; ?></td></tr>
            <tr><td>Frequency</td><td><?php echo htmlspecialchars($row['frequency']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <tr><td>Rate (ml/hr)</td><td><?php echo htmlspecialchars($row['rate_ml_hr']) ?: '<span class="empty-value">-</span>'; ?></td></tr>
            <tr><td>Total Volume (ml/day)</td><td><?php echo htmlspecialchars($row['total_volume']) ?: '<span class="empty-value">-</span>'; ?></td></tr>
            <tr><td>Flush Amount</td><td><?php echo htmlspecialchars($row['flush_amount']) ?: '<span class="empty-value">-</span>'; ?></td></tr>
            <tr><td>Flush Frequency</td><td><?php echo htmlspecialchars($row['flush_frequency']) ?: '<span class="empty-value">Not specified</span>'; ?></td></tr>
            <?php if (!empty($row['flush_other'])): ?>
            <tr><td>Flush Other</td><td><?php echo htmlspecialchars($row['flush_other']); ?></td></tr>
            <?php endif; ?>
            <tr><td>Tube Instructions</td><td><?php echo $row['tube_instructions'] ? nl2br(htmlspecialchars($row['tube_instructions'])) : '<span class="empty-value">None</span>'; ?></td></tr>
        </table>
    </div>

    <div class="section">
        <h4>Form Metadata</h4>
        <table>
            <tr><th>Field</th><th>Value</th></tr>
            <tr><td>Form ID</td><td><?php echo htmlspecialchars($row['id']); ?></td></tr>
            <tr><td>Patient ID</td><td><?php echo htmlspecialchars($row['pid']); ?></td></tr>
            <tr><td>Encounter</td><td><?php echo htmlspecialchars($row['encounter']); ?></td></tr>
            <tr><td>Created By</td><td><?php echo htmlspecialchars($row['user']); ?></td></tr>
            <tr><td>Date</td><td><?php echo htmlspecialchars($row['date']); ?></td></tr>
        </table>
    </div>

    <!-- Bottom Button Group -->
    <div class="button-group">
        <a class="edit-btn" href="<?php echo $edit_url; ?>" onclick="top.restoreSession()">
            <i class="fa fa-edit"></i> Edit
        </a>
        <a class="back-btn" href="javascript:void(0)" onclick="window.close();">
            <i class="fa fa-arrow-left"></i> Close
        </a>
    </div>
</body>
</html>