<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");

// Include Elephant.io
require_once __DIR__ . "/../../../vendor/autoload.php"; // adjust if your vendor folder is elsewhere
use ElephantIO\Client;
use ElephantIO\Engine\SocketIO\Version2X;

// Ensure an encounter is active
if (empty($_SESSION['encounter']) || $_SESSION['encounter'] == 0) {
    die("⚠️ Please open or create an encounter before saving this form.");
}

$encounter = $_SESSION['encounter'];
$pid = $_SESSION['pid'] ?? null;

// Handle allergies (multiple checkboxes)
$allergies = isset($_POST['allergies']) ? implode(',', $_POST['allergies']) : '';

// Collect all form data
$data = [
    'diet_type1' => $_POST['diet_type1'] ?? '',
    'diet_type2' => $_POST['diet_type2'] ?? '',
    'diet_type3' => $_POST['diet_type3'] ?? '',
    'diet_type4' => $_POST['diet_type4'] ?? '',
    'diet_extra' => $_POST['diet_extra'] ?? '',
    'texture_mod' => $_POST['texture_mod'] ?? '',
    'thickened_liquids' => $_POST['thickened_liquids'] ?? '',
    'supplements' => $_POST['supplements'] ?? '',
    'supplement' => $_POST['supplement'] ?? '',
    'supplement_other' => $_POST['supplement_other'] ?? '',
    'allergies' => $allergies,
    'additional_instructions' => $_POST['additional_instructions'] ?? '',
    'other_note' => $_POST['other_note'] ?? '',
    'feeding_route' => $_POST['feeding_route'] ?? '',
    'feeding_route_other' => $_POST['feeding_route_other'] ?? '',
    'formula' => $_POST['formula'] ?? '',
    'formula_other' => $_POST['formula_other'] ?? '',
    'method_admin' => $_POST['method_admin'] ?? '',
    'amount_ml' => $_POST['amount_ml'] ?? null,
    'frequency' => $_POST['frequency'] ?? '',
    'rate_ml_hr' => $_POST['rate_ml_hr'] ?? null,
    'intermittent_rate_ml_hr' => $_POST['intermittent_rate_ml_hr'] ?? null,
    'total_volume' => $_POST['total_volume'] ?? null,
    'flush_amount' => $_POST['flush_amount'] ?? null,
    'flush_frequency' => $_POST['flush_frequency'] ?? '',
    'flush_other' => $_POST['flush_other'] ?? '',
    'flushes_meds_cc' => $_POST['flushes_meds_cc'] ?? null,
    'flushes_acpc_cc' => $_POST['flushes_acpc_cc'] ?? null,
    'water_flush_amount' => $_POST['water_flush_amount'] ?? null,
    'water_flush_frequency' => $_POST['water_flush_frequency'] ?? '',
    'renal_protein' => $_POST['renal_protein'] ?? '',
    'diabetic_calories' => $_POST['diabetic_calories'] ?? '',
    'tube_instructions' => $_POST['tube_instructions'] ?? ''
];

// Save the form
$newid = formSubmit("form_diet_orders", $data, $_POST['id'] ?? null, $encounter, $pid);

// Register the form
sqlStatement(
    "INSERT INTO forms (date, encounter, form_name, form_id, pid, user, groupname, authorized, deleted, formdir)
     VALUES (NOW(), ?, ?, ?, ?, ?, ?, 1, 0, ?)",
    [$encounter, "Diet Orders Form", $newid, $pid, $_SESSION['authUser'], $_SESSION['authProvider'] ?? "Default", "diet_orders"]
);

if (file_exists(__DIR__ . '/../../../vendor/autoload.php') && class_exists(\ElephantIO\Client::class)) {
    try {
        $client = new Client(new Version2X("http://host.docker.internal:3000"));
        $client->initialize();
        $client->emit("diet_order_submitted", [
            "form_id" => $newid,
            "pid" => $pid,
            "encounter" => $encounter,
            "submitted_by" => $_SESSION['authUser'],
            "data" => $data
        ]);
        $client->close();
    } catch (\Throwable $e) {
        error_log("Socket.IO error: " . $e->getMessage());
    }
}

// Redirect to view the saved form
    header("Location: view.php?id=$newid");
exit;
