<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");
use OpenEMR\Core\Header;
?>
<html>
<head>
    <title>Diet Orders Form</title>
    <?php Header::setupHeader(['common']); ?>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 20px;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h3 {
            color: #007BFF;
        }
        label {
            font-weight: bold;
            display: block;
            margin-top: 15px;
        }
        select, input[type="text"], input[type="number"], textarea {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            box-sizing: border-box;
        }
        input[type="checkbox"] {
            margin-right: 10px;
        }
        .form-section {
            margin-bottom: 20px;
            padding: 15px;
            background: #ffffff;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        input[type="submit"] {
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 4px;
            padding: 10px 15px;
            cursor: pointer;
            font-size: 16px;
        }
        input[type="submit"]:hover {
            background-color: #0056b3;
        }
    </style>
    <script>
    $(function(){
        $("#diet_type1").change(function(){
            var val = $(this).val();
            if(val == "Renal Diet"){
                $("#diet_extra").html('<option>40 gm Protein</option><option>60 gm Protein</option><option value="other">Other</option>');
            } else if(val == "Diabetic Diet"){
                $("#diet_extra").html('<option>1500 Calories</option><option>1800 Calories</option><option>2000 Calories</option><option value="other">Other</option>');
            } else {
                $("#diet_extra").html('<option>Not Applicable</option>');
            }
            $("#diet_extra_other").hide();
            if(val=="other") $("#diet_type1_other").show(); else $("#diet_type1_other").hide();
        });
        $("#diet_type1_other").hide();

        $("#diet_extra").change(function(){
            if($(this).val() == "other") $("#diet_extra_other").show(); else $("#diet_extra_other").hide();
        });
        $("#diet_extra_other").hide();

        $("#feeding_route").change(function(){
            if($(this).val() == "other") $("#feeding_route_other").show(); else $("#feeding_route_other").hide();
        });
        $("#feeding_route_other").hide();

        $("#formula").change(function(){
            if($(this).val() == "other") $("#formula_other").show(); else $("#formula_other").hide();
        });
        $("#formula_other").hide();

        $("#flush_frequency").change(function(){
            if($(this).val() == "other") $("#flush_other").show(); else $("#flush_other").hide();
        });
        $("#flush_other").hide();

        $("#method_admin").change(function(){
            if($(this).val()=="Bolus (syringe/gravity)") $("#tube_extra_fields").show(); else $("#tube_extra_fields").hide();
        });
        $("#tube_extra_fields").hide();
    });
    </script>
</head>
<body>
    <h3>Diet Orders</h3>
    <form method="post" action="<?php echo $rootdir; ?>/forms/diet_orders/save.php">
        <div class="form-section">
            <label>Diet Type 1:</label>
            <select name="diet_type1" id="diet_type1">
                <option>Regular</option>
                <option>NPO</option>
                <option>Clear Liquid</option>
                <option>Full Liquid</option>
                <option>GI Soft Diet</option>
                <option>Renal Diet</option>
                <option>Cardiac Diet</option>
                <option>Diabetic Diet</option>
                <option>No Concentrated Sweets</option>
                <option>Low Sodium</option>
                <option>High Protein</option>
                <option>Hi Fiber</option>
                <option value="other">Other</option>
            </select>
            <input type="text" name="diet_type1_other" id="diet_type1_other" placeholder="Specify" style="display:none;">

            <label>Diet Details:</label>
            <select name="diet_extra" id="diet_extra">
                <option>Not Applicable</option>
            </select>
            <input type="text" name="diet_extra_other" id="diet_extra_other" placeholder="Enter custom diet details" style="display:none;">

            <label>Diet Type 2 (Secondary):</label>
            <select name="diet_type2" id="diet_type2">
                <option value="">Select secondary diet</option>
                <option>Regular</option>
                <option>NPO</option>
                <option>Clear Liquid</option>
                <option>Full Liquid</option>
                <option>GI Soft Diet</option>
                <option>Renal Diet</option>
                <option>Cardiac Diet</option>
                <option>Diabetic Diet</option>
            </select>

            <label>Diet Type 3 (Tertiary):</label>
            <select name="diet_type3" id="diet_type3">
                <option value="">Select tertiary diet</option>
                <option>Regular</option>
                <option>NPO</option>
                <option>Clear Liquid</option>
                <option>Full Liquid</option>
                <option>GI Soft Diet</option>
                <option>Renal Diet</option>
                <option>Cardiac Diet</option>
                <option>Diabetic Diet</option>
            </select>

            <label>Diet Type 4:</label>
            <select name="diet_type4" id="diet_type4">
                <option value="">Select diet</option>
                <option>Regular</option>
                <option>NPO</option>
                <option>Clear Liquid</option>
                <option>Full Liquid</option>
                <option>GI Soft Diet</option>
                <option>Renal Diet</option>
                <option>Cardiac Diet</option>
                <option>Diabetic Diet</option>
            </select>

            <label>Renal Diet Protein:</label>
            <select name="renal_protein" id="renal_protein">
                <option value="">Select protein allowance</option>
                <option>None</option>
                <option>40 gm Protein</option>
                <option>60 gm Protein</option>
                <option>__gm Protein</option>
            </select>

            <label>Diabetic Calories:</label>
            <select name="diabetic_calories" id="diabetic_calories">
                <option value="">Select calories</option>
                <option>None</option>
                <option>1500 Calories</option>
                <option>1800 Calories</option>
                <option>2000 Calories</option>
                <option>__Calories</option>
            </select>

            <label>Other Note:</label>
            <input type="text" name="other_note" placeholder="Free text">

            <label>Texture Modification:</label>
            <select name="texture_mod">
                <option>Regular</option>
                <option>Mechanical soft</option>
                <option>Chopped</option>
                <option>Minced</option>
                <option>Pureed</option>
            </select>

            <label>Thickened Liquids:</label>
            <select name="thickened_liquids" id="thickened_liquids">
                <option value="">Select</option>
                <option>None</option>
                <option>Nectar</option>
                <option>Honey</option>
                <option>Pudding</option>
            </select>

            <label>Supplements:</label>
            <select name="supplements">
                <option>None</option>
                <option>Ensure</option>
                <option>Ensure Plus</option>
                <option>Glucerna Shake</option>
                <option>Protein Powder</option>
            </select>

            <label>Common Allergies:</label><br>
            <input type="checkbox" name="allergies[]" value="Milk"> Milk/Dairy
            <input type="checkbox" name="allergies[]" value="Egg"> Egg
            <input type="checkbox" name="allergies[]" value="Soy"> Soy
            <input type="checkbox" name="allergies[]" value="Wheat"> Wheat/Gluten
            <input type="checkbox" name="allergies[]" value="Peanut"> Peanut

            <label>Additional Instructions:</label>
            <textarea name="additional_instructions" rows="4"></textarea>
        </div>

        <div class="form-section">
            <h3>Tube Feeding Orders</h3>
            <label>Feeding Route:</label>
            <select name="feeding_route" id="feeding_route">
                <option>NG (Nasogastric)</option>
                <option>OG (Orogastric)</option>
                <option>PEG (Percutaneous Endoscopic Gastrostomy)</option>
                <option>PEJ (Percutaneous Endoscopic Jejunostomy)</option>
                <option>NJ (Nasojejunal)</option>
                <option value="other">Other</option>
            </select>
            <input type="text" name="feeding_route_other" id="feeding_route_other" placeholder="If Other, specify" style="display:none;">

            <label>Formula:</label>
            <select name="formula" id="formula">
                <option>Jevity 1.0</option>
                <option>Jevity 1.2</option>
                <option>Osmolite 1.2</option>
                <option>Osmolite 1.5</option>
                <option>Glucerna 1.2</option>
                <option>Nepro with Carb Steady</option>
                <option>Promote</option>
                <option>TwoCal HN</option>
                <option>Peptamen</option>
                <option>Vital AF 1.2</option>
                <option value="other">Other</option>
            </select>
            <input type="text" name="formula_other" id="formula_other" placeholder="If Other, specify" style="display:none;">

            <label>Method of Administration:</label>
            <select name="method_admin" id="method_admin">
                <option>Continuous (via pump)</option>
                <option>Cyclic (overnight, timed hours)</option>
                <option>Bolus (syringe/gravity)</option>
                <option>Intermittent (scheduled times)</option>
            </select>

            <div id="tube_extra_fields">
                <label>Amount (ml):</label>
                <input type="number" name="amount_ml">

                <label>Frequency:</label>
                <select name="frequency">
                    <option>Every 4 hr</option>
                    <option>Every 6 hrs</option>
                    <option>Every ___ hrs</option>
                </select>

                <label>Rate (ml/hr):</label>
                <input type="number" name="rate_ml_hr">

                <label>Intermittent Rate (ml/hr):</label>
                <input type="number" name="intermittent_rate_ml_hr">

                <label>Total Volume (ml/day):</label>
                <input type="number" name="total_volume">
            </div>

            <h4>Water Flushes</h4>
            <label>Amount (ml):</label>
            <input type="number" name="flush_amount">

            <label>Frequency:</label>
            <select name="flush_frequency" id="flush_frequency">
                <option>Every 1 hr</option>
                <option>Every 2 hrs</option>
                <option>Every 4 hrs</option>
                <option>With Medications</option>
                <option value="other">Other</option>
            </select>
            <input type="text" name="flush_other" id="flush_other" placeholder="If Other, specify" style="display:none;">

            <label>Flushes with meds (cc):</label>
            <input type="number" name="flushes_meds_cc">

            <label>Flushes (ac/pc feed) (cc):</label>
            <input type="number" name="flushes_acpc_cc">

            <label>Water Flush Amount (ml):</label>
            <input type="number" name="water_flush_amount">

            <label>Water Flush Frequency:</label>
            <select name="water_flush_frequency">
                <option value="">Select frequency</option>
                <option>Every 1 hr</option>
                <option>Every 2 hrs</option>
                <option>Every 4 hrs</option>
                <option>With Medications</option>
            </select>

            <label>Additional Tube Feeding Instructions:</label>
            <textarea name="tube_instructions" rows="4"></textarea>
        </div>

        <div class="form-section">
            <h3>Supplements</h3>
            <label>Supplement:</label>
            <select name="supplement">
                <option value="">Select supplement</option>
                <option>Ensure</option>
                <option>Ensure Plus</option>
                <option>Glucerna Shake</option>
                <option>Protein Powder</option>
            </select>
            <label>Other (text)</label>
            <input type="text" name="supplement_other" placeholder="Other supplement">
        </div>

        <input type="submit" value="Save">
    </form>
</body>
</html>