<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");

$res = sqlStatement("SELECT * FROM form_diet_orders WHERE pid = ? ORDER BY date DESC", array($pid));
?>

<html>
<head>
    <title>Diet Orders List</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #007BFF;
            color: white;
        }
        a.btn {
            padding: 6px 10px;
            border-radius: 4px;
            text-decoration: none;
            color: white;
        }
        .btn-view { background-color: #17a2b8; }
        .btn-edit { background-color: #28a745; }
    </style>
</head>
<body>
    <h3>Diet Orders</h3>
    <table>
        <tr>
            <th>ID</th>
            <th>Date</th>
            <th>Diet Type 1</th>
            <th>Formula</th>
            <th>Actions</th>
        </tr>

        <?php
        while ($row = sqlFetchArray($res)) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['id']) . "</td>";
            echo "<td>" . htmlspecialchars($row['date']) . "</td>";
            echo "<td>" . htmlspecialchars($row['diet_type1']) . "</td>";
            echo "<td>" . htmlspecialchars($row['formula']) . "</td>";
            echo "<td>
                    <a class='btn btn-view' href='view.php?id=" . attr_url($row['id']) . "'>View</a>
                    <a class='btn btn-edit' href='new.php?id=" . attr_url($row['id']) . "&mode=edit'>Edit</a>
                  </td>";
            echo "</tr>";
        }
        ?>
    </table>
</body>
</html>
