<?php
require_once("../../globals.php");
require_once("$srcdir/api.inc");
?>
<html>
<head>
<script src="/public/assets/jquery/dist/jquery.min.js"></script>
<script>
$(function(){
  $("#diet_type1").change(function(){
    var val = $(this).val();
    if(val == "Renal Diet"){
      $("#diet_extra").html('<option>40 gm Protein</option><option>60 gm Protein</option><option>Other</option>');
    } else if(val == "Diabetic Diet"){
      $("#diet_extra").html('<option>1500 Calories</option><option>1800 Calories</option><option>2000 Calories</option><option>Other</option>');
    } else {
      $("#diet_extra").html('<option>Not Applicable</option>');
    }
  });
});
</script>
</head>
<body>
<h3>Diet Orders</h3>
<form method="post" action="save.php">
  <!-- Existing Diet Orders Fields -->
  <label>Diet Type 1:</label>
  <select name="diet_type1" id="diet_type1">
    <option>Regular</option>
    <option>NPO</option>
    <option>Clear Liquid</option>
    <option>Full Liquid</option>
    <option>GI Soft Diet</option>
    <option>Renal Diet</option>
    <option>Cardiac Diet</option>
    <option>Diabetic Diet</option>
  </select><br><br>

  <label>Diet Details:</label>
  <select name="diet_extra" id="diet_extra">
    <option>Not Applicable</option>
  </select><br><br>

  <label>Texture Modification:</label>
  <select name="texture_mod">
    <option>Regular</option>
    <option>Mechanical soft</option>
    <option>Chopped</option>
    <option>Minced</option>
    <option>Pureed</option>
    <option>Thickened Liquids</option>
  </select><br><br>

  <label>Supplements:</label>
  <select name="supplements">
    <option>None</option>
    <option>Ensure</option>
    <option>Ensure Plus</option>
    <option>Glucerna Shake</option>
    <option>Protein Powder</option>
  </select><br><br>

  <label>Common Allergies:</label><br>
  <input type="checkbox" name="allergies[]" value="Milk"> Milk/Dairy
  <input type="checkbox" name="allergies[]" value="Egg"> Egg
  <input type="checkbox" name="allergies[]" value="Soy"> Soy
  <input type="checkbox" name="allergies[]" value="Wheat"> Wheat/Gluten
  <input type="checkbox" name="allergies[]" value="Peanut"> Peanut
  <br><br>

  <label>Additional Instructions:</label><br>
  <textarea name="additional_instructions" rows="4" cols="50"></textarea><br><br>


  <!-- New Tube Feeding Orders Section -->
  <h3>Tube Feeding Orders</h3>

  <label>Feeding Route:</label>
  <select name="feeding_route" id="feeding_route">
    <option>NG (Nasogastric)</option>
    <option>OG (Orogastric)</option>
    <option>PEG (Percutaneous Endoscopic Gastrostomy)</option>
    <option>PEJ (Percutaneous Endoscopic Jejunostomy)</option>
    <option>NJ (Nasojejunal)</option>
    <option>Other</option>
  </select>
  <input type="text" name="feeding_route_other" placeholder="If Other, specify"><br><br>

  <label>Formula:</label>
  <select name="formula" id="formula">
    <option>Jevity 1.0</option>
    <option>Jevity 1.5</option>
    <option>Osmolite 1.2</option>
    <option>Osmolite 1.5</option>
    <option>Glucerna 1.2</option>
    <option>Nepro with Carb Steady</option>
    <option>Promote</option>
    <option>TwoCal HN</option>
    <option>Peptamen</option>
    <option>Vital AF 1.2</option>
    <option>Other</option>
  </select>
  <input type="text" name="formula_other" placeholder="If Other, specify"><br><br>

  <label>Method of Administration:</label>
  <select name="method_admin" id="method_admin">
    <option>Continuous (via pump)</option>
    <option>Cyclic (overnight, timed hours)</option>
    <option>Bolus (syringe/gravity)</option>
    <option>Intermittent (scheduled times)</option>
  </select><br><br>

  <label>Amount (ml):</label>
  <input type="number" name="amount_ml"><br><br>

  <label>Frequency:</label>
  <select name="frequency">
    <option>Every 4 hr</option>
    <option>Every 6 hrs</option>
    <option>Every ___ hrs</option>
  </select><br><br>

  <label>Rate (ml/hr):</label>
  <input type="number" name="rate_ml_hr"><br><br>

  <label>Total Volume (ml/day):</label>
  <input type="number" name="total_volume"><br><br>

  <h4>Water Flushes</h4>
  <label>Amount (ml):</label>
  <input type="number" name="flush_amount"><br><br>

  <label>Frequency:</label>
  <select name="flush_frequency">
    <option>Every 1 hr</option>
    <option>Every 2 hrs</option>
    <option>Every 4 hrs</option>
    <option>With Medications</option>
    <option>Other</option>
  </select>
  <input type="text" name="flush_other" placeholder="If Other, specify"><br><br>

  <label>Additional Tube Feeding Instructions:</label><br>
  <textarea name="tube_instructions" rows="4" cols="50"></textarea><br><br>

  <input type="submit" value="Save">
</form>
</body>
</html>
