<?php
include_once("../../globals.php");
include_once("$srcdir/api.inc");

// Get form id
$formid = $_GET["id"] ?? 0;

// Fetch admission record
$data = [];
if ($formid) {
    $sql = "SELECT * FROM form_admission WHERE id = ?";
    $res = sqlStatement($sql, [$formid]);
    $data = sqlFetchArray($res);
}

formHeader("Admission Form - View");
?>
<html>
<head>
    <title>Admission Form</title>
    <style>
        .admission-view {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            font-family: Arial, sans-serif;
        }
        .admission-view h2 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 20px;
        }
        .detail-row {
            margin: 12px 0;
            padding: 10px;
            border-bottom: 1px solid #eee;
        }
        .detail-row:last-child { border-bottom: none; }
        .detail-label { font-weight: bold; color: #34495e; display: inline-block; width: 160px; }
        .detail-value { color: #2c3e50; }
        .status-admitted { color: green; font-weight: bold; }
        .status-discharged { color: red; font-weight: bold; }
        .btn-back, .btn-discharge, .btn-transfer {
            display: block; margin-top: 20px; text-align: center;
            padding: 10px; border-radius: 6px; text-decoration: none; font-weight: bold;
        }
        .btn-back { background: #007bff; color: #fff; }
        .btn-back:hover { background: #0056b3; }
        .btn-discharge { background: #e74c3c; color: #fff; }
        .btn-discharge:hover { background: #c0392b; }
        .btn-transfer { background: #f39c12; color: #fff; }
        .btn-transfer:hover { background: #d35400; }
        .btn-group { display: flex; gap: 10px; margin-top: 20px; }
    </style>
</head>
<body>
<div class="admission-view">
    <h2>Admission Summary</h2>

    <?php if ($data): ?>
        <div class="detail-row">
            <span class="detail-label">Admission Date:</span>
            <span class="detail-value"><?= htmlspecialchars($data['date_admission']) ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Doctor:</span>
            <span class="detail-value"><?= htmlspecialchars($data['doctor']) ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Ward:</span>
            <span class="detail-value"><?= htmlspecialchars($data['ward']) ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Bed:</span>
            <span class="detail-value"><?= htmlspecialchars($data['bed']) ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Status:</span>
            <span class="detail-value 
                <?= $data['status'] === 'Admitted' ? 'status-admitted' : 'status-discharged' ?>">
                <?= htmlspecialchars($data['status']) ?>
            </span>
        </div>
        <?php if ($data['status'] === 'Discharged' && !empty($data['discharge_date'])): ?>
        <div class="detail-row">
            <span class="detail-label">Discharge Date:</span>
            <span class="detail-value"><?= htmlspecialchars($data['discharge_date']) ?></span>
        </div>
        <?php endif; ?>

        <?php if ($data['status'] === 'Admitted'): ?>
        <div class="btn-group">
            <!-- Discharge button -->
            <a href="<?php echo $rootdir; ?>/forms/form_discharge/new.php?id=<?= $data['id'] ?>" class="btn-discharge">
                ⚡ Discharge Patient
            </a>

            <!-- Transfer button -->
            <a href="<?php echo $rootdir; ?>/forms/form_transfer/new.php?id=<?= $data['id'] ?>" class="btn-transfer">
                🔄 Transfer Patient
            </a>
        </div>
        <?php endif; ?>

    <?php else: ?>
        <p>No admission data found.</p>
    <?php endif; ?>

    <a href="<?php echo $rootdir; ?>/patient_file/encounter/encounter_top.php" class="btn-back">⬅ Back to Encounter</a>
</div>
</body>
</html>
<?php formFooter(); ?>
