<?php
include_once("../../globals.php");
include_once("$srcdir/api.inc");

if ($_POST) {

    // ----------------------------
    // 1. Ensure encounter is active
    // ----------------------------
    if (empty($_SESSION["encounter"]) || $_SESSION["encounter"] == 0) {
        die("⚠️ Please open or create an encounter before saving this form.");
    }

    // ----------------------------
    // 2. Check if selected bed is already occupied
    // ----------------------------
    $res = sqlStatement(
        "SELECT * FROM form_admission WHERE ward = ? AND bed = ? AND status = 'Admitted'",
        [$_POST['ward'], $_POST['bed']]
    );
    if (sqlNumRows($res) > 0) {
        die("⚠️ Bed {$_POST['bed']} in Ward {$_POST['ward']} is already occupied. Please select another bed.");
    }

    // ----------------------------
    // 3. Insert new admission
    // ----------------------------
    $newid = formSubmit("form_admission", $_POST, '', $userauthorized);

    // Ensure status is set to Admitted
    sqlStatement("UPDATE form_admission SET status='Admitted' WHERE id=?", [$newid]);

    // ----------------------------
    // 4. Register form in OpenEMR forms table
    // ----------------------------
    sqlStatement(
        "INSERT INTO forms (date, encounter, form_name, form_id, pid, user, groupname, authorized, deleted, formdir)
         VALUES (NOW(), ?, ?, ?, ?, ?, ?, 1, 0, ?)",
        array(
            $_SESSION["encounter"],            // Encounter ID
            "Admission Form",                  // Label in Encounter summary
            $newid,                            // form_admission.id
            $_SESSION["pid"],                  // Patient ID
            $_SESSION["authUser"],             // Current user
            $_SESSION["authProvider"] ?? "Default", // Group name
            "admission_form"                   // Folder name
        )
    );

    // ----------------------------
    // 5. Redirect to view page
    // ----------------------------
    header("Location: $rootdir/forms/admission_form/view.php?id=" . attr_url($newid));
    exit;

}
