<?php
include_once("../../globals.php");
include_once("$srcdir/api.inc");

// Step 1: Handle hospital structure from POST
$selectedHospitalStructure = $_POST['hospital_structure'] ?? "";

// Fetch currently admitted beds
$occupiedBeds = [];
$sql = "SELECT ward, bed FROM form_admission WHERE status = 'Admitted'";
$res = sqlStatement($sql);
while ($row = sqlFetchArray($res)) {
    $occupiedBeds[$row['ward']][] = $row['bed'];
}

formHeader("Patient Admission Form");
?>
<html>
<head>
    <title>Admission Form</title>
    <style>
        .admission-form {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        .admission-form h2 { text-align: center; margin-bottom: 20px; color: #2c3e50; }
        .form-group { margin-bottom: 15px; }
        label { font-weight: 600; display: block; margin-bottom: 5px; }
        select, input[type="datetime-local"], input[readonly] {
            width: 100%; padding: 8px; border-radius: 5px; border: 1px solid #ccc;
        }
        .btn-save {
            width: 100%; padding: 10px; background: #007bff;
            border: none; color: #fff; font-size: 16px; font-weight: 600;
            border-radius: 6px; cursor: pointer;
        }
        .btn-save:hover { background: #0056b3; }
    </style>
    <script>
    // Occupied beds from PHP
    var occupiedBeds = <?php echo json_encode($occupiedBeds); ?>;

    function updateBeds() {
        var ward = document.getElementById("ward").value;
        var bedSelect = document.getElementById("bed");
        bedSelect.innerHTML = "";

        let beds = [];
        if (ward === "General") beds = ["G1","G2","G3","G4","G5","G6","G7","G8","G9","G10"];
        else if (ward === "Cabin") beds = ["C1","C2","C3","C4","C5","C6","C7","C8","C9","C10"];
        else if (ward === "ICU") beds = ["ICU1","ICU2","ICU3"];

        let wardOccupied = occupiedBeds[ward] || [];
        let firstAvailable = true;

        beds.forEach(function(b) {
            let opt = document.createElement("option");
            opt.value = b;
            if (wardOccupied.includes(b)) {
                opt.disabled = true;
                opt.text = b + " (Occupied)";
            } else {
                opt.text = b + " (Available)";
                if (firstAvailable) {
                    opt.selected = true;
                    firstAvailable = false;
                }
            }
            bedSelect.add(opt);
        });
    }
    </script>
</head>
<body>
    <form class="admission-form" method="post" action="<?php echo $rootdir ?>/forms/admission_form/save.php?mode=new">
        <h2>Patient Admission Form</h2>

        <!-- Hospital Structure -->
        <div class="form-group">
            <label>Hospital Structure</label>
            <select name="hospital_structure" required>
                <option value="">-- Select Structure --</option>
                <option value="Surgical" <?php if($selectedHospitalStructure=="Surgical") echo "selected";?>>Surgical</option>
                <option value="Clinical" <?php if($selectedHospitalStructure=="Clinical") echo "selected";?>>Clinical</option>
            </select>
        </div>

        <!-- Admission Date -->
        <div class="form-group">
            <label for="date_admission">Admission Date</label>
            <input type="datetime-local" id="date_admission" name="date_admission" required>
        </div>

        <!-- Doctor -->
        <div class="form-group">
            <label for="doctor">Doctor</label>
            <select id="doctor" name="doctor" required>
                <option value="">-- Select Doctor --</option>
                <option>Dr. Smith</option>
                <option>Dr. John</option>
                <option>Dr. Alice</option>
            </select>
        </div>

        <!-- Ward -->
        <div class="form-group">
            <label for="ward">Ward</label>
            <select id="ward" name="ward" onchange="updateBeds()" required>
                <option value="">-- Select Ward --</option>
                <option value="General">General Ward</option>
                <option value="Cabin">Cabin</option>
                <option value="ICU">ICU</option>
            </select>
        </div>

        <!-- Bed -->
        <div class="form-group">
            <label for="bed">Bed</label>
            <select id="bed" name="bed" required>
                <option value="">-- Select Bed --</option>
            </select>
        </div>

        <input type="hidden" name="status" value="Admitted">
        <button type="submit" class="btn-save">💾 Save Admission</button>
    </form>
</body>
</html>
<?php formFooter(); ?>
