Param(
    [string]$ProjectRoot = (Split-Path -Parent $MyInvocation.MyCommand.Path)
)

$ErrorActionPreference = 'Stop'

function Ensure-Dir($path) {
    if (-not (Test-Path $path)) {
        New-Item -ItemType Directory -Path $path -Force | Out-Null
    }
}

function Copy-All($src, $dest) {
    Ensure-Dir $dest
    if (Test-Path $src) {
        Copy-Item "$src\*" $dest -Recurse -Force -ErrorAction Stop
    } else {
        Write-Warning "Source not found: $src"
    }
}

function Copy-DistOrAll($pkgName, $srcBase, $assetsBase) {
    $srcDist = Join-Path $srcBase 'dist'
    $dest = Join-Path $assetsBase $pkgName
    if (Test-Path $srcDist) {
        Copy-All $srcDist (Join-Path $dest 'dist')
    } else {
        Copy-All $srcBase $dest
    }
}

$node = Join-Path $ProjectRoot 'node_modules'
$napa = $ProjectRoot # default napa target (fallback)
$napaNode = Join-Path $ProjectRoot 'node_modules' # in this environment napa placed packages in node_modules
$assets = Join-Path $ProjectRoot 'public\assets'

# Core libs (special handling)
# jquery
Copy-DistOrAll 'jquery' (Join-Path $node 'jquery') $assets

# bootstrap (dist + scss)
$bootstrapSrc = Join-Path $node 'bootstrap'
$bootstrapDest = Join-Path $assets 'bootstrap'
Copy-All (Join-Path $bootstrapSrc 'dist') (Join-Path $bootstrapDest 'dist')
Copy-All (Join-Path $bootstrapSrc 'scss') (Join-Path $bootstrapDest 'scss')

# bootstrap-rtl from napa (dist + scss). Prefer node_modules, fallback to project root
$bsRtlSrc = Join-Path $napaNode 'bootstrap-rtl'
if (-not (Test-Path $bsRtlSrc)) { $bsRtlSrc = Join-Path $napa 'bootstrap-rtl' }
$bsRtlDest = Join-Path $assets 'bootstrap-rtl'
Copy-All (Join-Path $bsRtlSrc 'dist') (Join-Path $bsRtlDest 'dist')
Copy-All (Join-Path $bsRtlSrc 'scss') (Join-Path $bsRtlDest 'scss')

# fontawesome (css + scss + webfonts)
$faSrc = Join-Path $node '@fortawesome\fontawesome-free'
$faDest = Join-Path $assets '@fortawesome\fontawesome-free'
Copy-All (Join-Path $faSrc 'css') (Join-Path $faDest 'css')
Copy-All (Join-Path $faSrc 'scss') (Join-Path $faDest 'scss')
Copy-All (Join-Path $faSrc 'webfonts') (Join-Path $faDest 'webfonts')

# moment (min + moment.js)
$momentSrc = Join-Path $node 'moment'
$momentDest = Join-Path $assets 'moment'
Copy-All (Join-Path $momentSrc 'min') (Join-Path $momentDest 'min')
if (Test-Path (Join-Path $momentSrc 'moment.js')) {
    Ensure-Dir $momentDest
    Copy-Item (Join-Path $momentSrc 'moment.js') (Join-Path $momentDest 'moment.js') -Force
}

# dwv (dist + decoders + locales)
$dwvSrc = Join-Path $node 'dwv'
$dwvDest = Join-Path $assets 'dwv'
Copy-All (Join-Path $dwvSrc 'dist') (Join-Path $dwvDest 'dist')
Copy-All (Join-Path $dwvSrc 'decoders') (Join-Path $dwvDest 'decoders')
Copy-All (Join-Path $dwvSrc 'locales') (Join-Path $dwvDest 'locales')

# DataTables and related
Copy-DistOrAll 'datatables.net' (Join-Path $node 'datatables.net') $assets
Copy-DistOrAll 'datatables.net-bs4' (Join-Path $node 'datatables.net-bs4') $assets
Copy-DistOrAll 'datatables.net-dt' (Join-Path $node 'datatables.net-dt') $assets
Copy-DistOrAll 'datatables.net-jqui' (Join-Path $node 'datatables.net-jqui') $assets
Copy-DistOrAll 'datatables.net-colreorder' (Join-Path $node 'datatables.net-colreorder') $assets
Copy-DistOrAll 'datatables.net-colreorder-dt' (Join-Path $node 'datatables.net-colreorder-dt') $assets
Copy-DistOrAll 'datatables.net-scroller' (Join-Path $node 'datatables.net-scroller') $assets
Copy-DistOrAll 'datatables.net-scroller-jqui' (Join-Path $node 'datatables.net-scroller-jqui') $assets

# Select2
Copy-DistOrAll 'select2' (Join-Path $node 'select2') $assets

# Validation, jszip, jspdf, summernote
Copy-DistOrAll 'jquery-validation' (Join-Path $node 'jquery-validation') $assets
Copy-DistOrAll 'jszip' (Join-Path $node 'jszip') $assets
Copy-DistOrAll 'jspdf' (Join-Path $node 'jspdf') $assets
Copy-DistOrAll 'summernote' (Join-Path $node 'summernote') $assets

# Misc common libs
Copy-DistOrAll 'underscore' (Join-Path $node 'underscore') $assets
Copy-DistOrAll 'backbone' (Join-Path $node 'backbone') $assets
Copy-DistOrAll 'dropzone' (Join-Path $node 'dropzone') $assets
Copy-DistOrAll 'dompurify' (Join-Path $node 'dompurify') $assets
Copy-DistOrAll 'interactjs' (Join-Path $node 'interactjs') $assets
Copy-DistOrAll 'i18next' (Join-Path $node 'i18next') $assets
Copy-DistOrAll 'i18next-browser-languagedetector' (Join-Path $node 'i18next-browser-languagedetector') $assets
Copy-DistOrAll 'i18next-xhr-backend' (Join-Path $node 'i18next-xhr-backend') $assets
Copy-DistOrAll 'knockout' (Join-Path $node 'knockout') $assets
Copy-DistOrAll 'konva' (Join-Path $node 'konva') $assets
Copy-DistOrAll 'numeral' (Join-Path $node 'numeral') $assets
Copy-DistOrAll 'sortablejs' (Join-Path $node 'sortablejs') $assets
Copy-DistOrAll 'validate.js' (Join-Path $node 'validate.js') $assets
Copy-DistOrAll 'hotkeys-js' (Join-Path $node 'hotkeys-js') $assets
Copy-DistOrAll 'flot' (Join-Path $node 'flot') $assets
Copy-DistOrAll 'chart.js' (Join-Path $node 'chart.js') $assets
Copy-DistOrAll 'chartjs-adapter-date-fns' (Join-Path $node 'chartjs-adapter-date-fns') $assets
Copy-DistOrAll 'purecss' (Join-Path $node 'purecss') $assets

# Git-based or napa dependencies: prefer node_modules, fallback to project root
function Copy-Napa($name) {
    $src = Join-Path $napaNode $name
    if (-not (Test-Path $src)) { $src = Join-Path $napa $name }
    Copy-All $src (Join-Path $assets $name)
}

Copy-Napa 'jquery-ui'
Copy-Napa 'jquery-ui-themes'
Copy-Napa 'jquery-creditcardvalidator'
Copy-Napa 'jquery-panelslider'
Copy-Napa 'literallycanvas'
Copy-Napa 'react'
Copy-Napa 'lforms'

Write-Host "Assets copied to $assets" -ForegroundColor Green
