<?php
require_once("../../../globals.php");
require_once($GLOBALS['srcdir'] . "/api.inc");

// -------------------------------
// TEMPORARY TESTING: disable OAuth
// -------------------------------
// Comment out for production
// if (!oauthAuthenticate()) {
//     http_response_code(401);
//     echo json_encode(["error" => "Unauthorized"]);
//     exit;
// }

header("Content-Type: application/json");

// Get optional ID from query string ?id=4
$id = isset($_GET['id']) ? intval($_GET['id']) : null;

if ($id) {
    // Fetch single form
    $row = sqlQuery("SELECT * FROM form_diet_orders WHERE id = ?", [$id]);
    if (!$row) {
        http_response_code(404);
        echo json_encode(["error" => "Form not found"]);
        exit;
    }

    $data = [
        'form_id' => $row['id'],
        'pid' => $row['pid'],
        'encounter' => $row['encounter'],
        'submitted_by' => $row['user'],
        'submitted_at' => $row['date'],
        'data' => [
            'diet_type1' => $row['diet_type1'],
            'diet_type2' => $row['diet_type2'],
            'texture_mod' => $row['texture_mod'],
            'supplements' => $row['supplements'],
            'allergies' => $row['allergies'],
            'additional_instructions' => $row['additional_instructions'],
            'feeding_route' => $row['feeding_route'],
            'feeding_route_other' => $row['feeding_route_other'],
            'formula' => $row['formula'],
            'formula_other' => $row['formula_other'],
            'method_admin' => $row['method_admin'],
            'amount_ml' => $row['amount_ml'],
            'frequency' => $row['frequency'],
            'rate_ml_hr' => $row['rate_ml_hr'],
            'total_volume' => $row['total_volume'],
            'flush_amount' => $row['flush_amount'],
            'flush_frequency' => $row['flush_frequency'],
            'flush_other' => $row['flush_other'],
            'tube_instructions' => $row['tube_instructions'],
        ]
    ];
    echo json_encode($data);
    exit;
} else {
    // Fetch all forms
    $rows = sqlStatement("SELECT * FROM form_diet_orders ORDER BY id DESC");
    $allData = [];
    while ($row = sqlFetchArray($rows)) {
        $allData[] = [
            'form_id' => $row['id'],
            'pid' => $row['pid'],
            'encounter' => $row['encounter'],
            'submitted_by' => $row['user'],
            'submitted_at' => $row['date'],
            'data' => [
                'diet_type1' => $row['diet_type1'],
                'diet_type2' => $row['diet_type2'],
                'texture_mod' => $row['texture_mod'],
                'supplements' => $row['supplements'],
                'allergies' => $row['allergies'],
                'additional_instructions' => $row['additional_instructions'],
                'feeding_route' => $row['feeding_route'],
                'feeding_route_other' => $row['feeding_route_other'],
                'formula' => $row['formula'],
                'formula_other' => $row['formula_other'],
                'method_admin' => $row['method_admin'],
                'amount_ml' => $row['amount_ml'],
                'frequency' => $row['frequency'],
                'rate_ml_hr' => $row['rate_ml_hr'],
                'total_volume' => $row['total_volume'],
                'flush_amount' => $row['flush_amount'],
                'flush_frequency' => $row['flush_frequency'],
                'flush_other' => $row['flush_other'],
                'tube_instructions' => $row['tube_instructions'],
            ]
        ];
    }
    echo json_encode(["forms" => $allData]);
    exit;
}
