<?php

namespace OpenEMR\Custom;

use OpenEMR\Common\Database\QueryUtils;
use OpenEMR\Common\Http\HttpRestRouteHandlerBase;
use Slim\Http\Request;
use Slim\Http\Response;

class DietOrdersController extends HttpRestRouteHandlerBase
{
    // GET /diet-orders
    public function getAll(Request $request, Response $response, array $args): Response
    {
        $pid = $request->getQueryParam('pid');

        if ($pid) {
            $sql = "SELECT * FROM form_diet_orders WHERE pid = ?";
            $rows = QueryUtils::fetchRecords($sql, [$pid]);
        } else {
            $sql = "SELECT * FROM form_diet_orders ORDER BY id DESC";
            $rows = QueryUtils::fetchRecords($sql, []);
        }

        return $this->returnSuccess($response, $rows);
    }

    // POST /diet-orders
    public function create(Request $request, Response $response, array $args): Response
    {
        $data = $request->getParsedBody();

        if (empty($data['pid']) || empty($data['encounter'])) {
            return $this->returnError($response, "Missing pid or encounter", 422);
        }

        // Save using OpenEMR formSubmit
        $newid = formSubmit("form_diet_orders", $data, null, $data['encounter'], $data['pid']);

        return $this->returnSuccess($response, [
            "message" => "Diet order saved",
            "form_id" => $newid
        ]);
    }
}
