<?php
// Enable CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

// Database config
$host = 'db';
$port = 3306;
$user = 'openemr';
$pass = 'openemrpass';
$db   = 'openemr';

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

// Query with all fields
$sql = "
    SELECT 
        a.id,
        a.date,
        a.date_admission,
        a.hospital_structure,
        a.doctor,
        a.ward,
        a.bed,
        a.pid,
        a.encounter,
        a.user,
        a.groupname,
        a.authorized,
        a.activity,
        a.status,
        a.discharge_date,
        a.event_code,
        p.fname,
        p.lname,
        p.mname,
        p.DOB,
        p.sex,
        p.regdate
    FROM form_admission a
    LEFT JOIN patient_data p ON a.pid = p.pid
    WHERE 1=1
";

// Optional filters
if (!empty($_GET['pid'])) {
    $pid = intval($_GET['pid']);
    $sql .= " AND a.pid = $pid";
}
if (!empty($_GET['from']) && !empty($_GET['to'])) {
    $from = $conn->real_escape_string($_GET['from']);
    $to   = $conn->real_escape_string($_GET['to']);
    $sql .= " AND DATE(a.date_admission) BETWEEN '$from' AND '$to'";
}

$sql .= " ORDER BY a.id DESC";

$result = $conn->query($sql);
$data = [];

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $pid = intval($row['pid']);
        $admission_id = intval($row['id']);

        // 🧠 Determine encounter number (auto-increment logic)
        if ($pid) {
            $encQuery = $conn->query("SELECT MAX(encounter) AS max_enc FROM form_admission WHERE pid = $pid");
            $encData = $encQuery ? $encQuery->fetch_assoc() : ['max_enc' => 0];
            $current_encounter = intval($encData['max_enc']);

            if (empty($row['encounter']) || $row['encounter'] == 0) {
                $current_encounter += 1;
                $conn->query("UPDATE form_admission SET encounter = $current_encounter WHERE id = $admission_id");
                $row['encounter'] = $current_encounter;
            } else {
                $row['encounter'] = $current_encounter;
            }
        }

        // 🩺 Determine event code (unchanged logic)
        $event_code = 'A04'; // Default = registration
        if (!empty($row['id'])) {
            switch ($row['status']) {
                case 'Admitted':
                    $event_code = 'A01';
                    break;
                case 'Transferred':
                    $event_code = 'A02';
                    break;
                case 'Discharged':
                    $event_code = 'A03';
                    break;
            }
        }

        $row['event_code'] = $event_code;

        $data[] = $row;
    }
}

echo json_encode($data);
?>
