<?php
// Enable CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

// registration_api.php - fetch patient registration entries

$host   = 'db';
$port   = 3306;
$user   = 'openemr';
$pass   = 'openemrpass';
$db     = 'openemr';

// Connect to MySQL
$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

// Base query - fetch all patients
$sql = "SELECT pid, fname, lname, mname, DOB, sex, street, city, state, postal_code, phone_home, phone_biz, email 
        FROM patient_data WHERE 1=1";

// Optional: filter by patient ID
if (!empty($_GET['pid'])) {
    $pid = intval($_GET['pid']);
    $sql .= " AND pid = $pid";
}

// Optional: limit results
$limit = !empty($_GET['limit']) ? intval($_GET['limit']) : 10;
$sql .= " ORDER BY pid DESC LIMIT $limit";

$result = $conn->query($sql);

$registrations = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        // Inject the event code for registration
        $row['event_code'] = 'A04';
        $registrations[] = $row;
    }
}

// Output JSON
echo json_encode($registrations);
?>
