# OpenEMR Custom APIs Documentation

This document summarizes the custom APIs created to fetch data from OpenEMR forms. These APIs query the database directly and return JSON responses, making them accessible from LAN devices or other applications.

---

## Quick Reference Table

| API            | URL                        | HTTP Method | Optional Query Parameters                          |
| -------------- | -------------------------- | ----------- | -------------------------------------------------- |
| Diet Orders    | `/api/diet/index.php`      | GET         | pid (int), encounter (int), from (date), to (date) |
| Admission Form | `/api/admission/index.php` | GET         | pid (int), encounter (int), limit (int)            |
| Discharge Form | `/api/discharge/index.php` | GET         | pid (int), encounter (int), limit (int)            |

---

## Common Setup for All APIs

**Database Connection (Docker Compose)**

```php
$host = 'db';
$port = 3306;
$user = 'openemr';
$pass = 'openemrpass';
$db   = 'openemr';

$conn = new mysqli($host, $user, $pass, $db, $port);
```

**CORS Headers (allow access from other devices)**

```php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');
```

**Location**: All APIs are placed in the `api` folder under OpenEMR webroot:

```
/var/www/localhost/htdocs/openemr/api/
```

**Access URL Pattern**:

```
https://<server-ip>/api/<form-name>/index.php
```

**HTTP Methods Supported**: GET (all APIs), POST optional for future updates

---

## Notes / Recommendations

* All APIs return JSON responses suitable for frontend apps or external applications.
* APIs are directly querying the database, bypassing OpenEMR site logic.
* Security: Currently open for LAN usage. Consider adding API keys or authentication before exposing externally.
* Can be extended to support additional forms by following the same folder structure.
* CORS headers are included to allow cross-origin requests from any domain or frontend application.
