<?php
// Enable CORS for any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

// discharge_api.php - fetch discharged patients

// Docker Compose DB settings
$host   = 'db';
$port   = 3306;
$user   = 'openemr';
$pass   = 'openemrpass';
$db     = 'openemr';

// Connect to MySQL
$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

// Base query: only discharged patients + join patient info
$sql = "
    SELECT a.*, 
           p.fname, p.lname, p.mname, p.DOB, p.sex
    FROM form_discharge a
    LEFT JOIN patient_data p ON a.pid = p.pid
    WHERE 1=1
";

// Optional: filter by patient ID
if (!empty($_GET['pid'])) {
    $pid = intval($_GET['pid']);
    $sql .= " AND a.pid = $pid";
}

// Optional: filter by encounter
if (!empty($_GET['encounter'])) {
    $enc = intval($_GET['encounter']);
    $sql .= " AND a.encounter = $enc";
}

// Optional: limit results
$limit = !empty($_GET['limit']) ? intval($_GET['limit']) : 10;
$sql .= " ORDER BY a.discharge_date DESC LIMIT $limit";

$result = $conn->query($sql);

$discharged = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        // Add fixed event code for discharge
        $row['event_code'] = 'A03';
        $discharged[] = $row;
    }
}

// Output JSON
echo json_encode($discharged);
?>
