<?php
// Enable CORS for any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header('Content-Type: application/json');

// admission_api.php - fetch recent admission form entries

// Docker Compose DB settings
$host   = 'db';
$port   = 3306;
$user   = 'openemr';
$pass   = 'openemrpass';
$db     = 'openemr';

// Connect to MySQL
$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

// Build query with JOIN to patient_data
$sql = "
    SELECT a.*, 
           p.fname, p.lname, p.mname, p.DOB, p.sex
    FROM form_admission a
    LEFT JOIN patient_data p ON a.pid = p.pid
    WHERE 1=1
";

// Optional: filter by patient ID
if (!empty($_GET['pid'])) {
    $pid = intval($_GET['pid']);
    $sql .= " AND a.pid = $pid";
}

// Optional: filter by encounter
if (!empty($_GET['encounter'])) {
    $enc = intval($_GET['encounter']);
    $sql .= " AND a.encounter = $enc";
}

// Optional: limit number of results
$limit = !empty($_GET['limit']) ? intval($_GET['limit']) : 10;
$sql .= " ORDER BY a.id DESC LIMIT $limit";

$result = $conn->query($sql);

$admissions = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $pid = $row['pid'];
        $admission_id = $row['id'];

        // 🧠 Determine encounter number
        // Fetch highest encounter for the same patient
        $encQuery = $conn->query("SELECT MAX(encounter) AS max_enc FROM form_admission WHERE pid = $pid");
        $encData = $encQuery ? $encQuery->fetch_assoc() : ['max_enc' => 0];
        $current_encounter = intval($encData['max_enc']);

        // If this admission has encounter=0 or null, assign new increment
        if (empty($row['encounter']) || $row['encounter'] == 0) {
            $current_encounter += 1;

            // Update encounter in DB for this record
            $update = $conn->query("UPDATE form_admission SET encounter = $current_encounter WHERE id = $admission_id");
            $row['encounter'] = $current_encounter;
        }

        // ✅ Determine event code based on admission history
        $check = $conn->query("SELECT COUNT(*) AS cnt FROM form_admission WHERE pid = $pid AND id <> $admission_id");
        $count = $check->fetch_assoc()['cnt'];

        if ($count > 0) {
            $row['event_code'] = 'A05'; // Pre-admission
        } else {
            $row['event_code'] = 'A01'; // New admission
        }

        $admissions[] = $row;
    }
}

// Output JSON
echo json_encode($admissions);
?>
