# CHANGELOG.md

## [7.0.2.3](https://github.com/openemr/openemr/milestone/15?closed=1) - 2024-11-24

### Fixed
- Add new document template plugins ([#7836](https://github.com/openemr/openemr/issues/7836))
- Feat openemr b11 7742 decision support interventions ([#7743](https://github.com/openemr/openemr/pull/7743))
- Fix New Documents patient select for actions. ([#7812](https://github.com/openemr/openemr/issues/7812))
- Portal Settings card Default Signature leaves backdrop on save close. ([#7835](https://github.com/openemr/openemr/issues/7835))
- Portal Theme Resets to core theme. ([#7800](https://github.com/openemr/openemr/issues/7800))
- Update Office Notes ([#7811](https://github.com/openemr/openemr/issues/7811))
-  Patient Portal with no procedures throws error on viewing Customized Medical History Report ([#7814](https://github.com/openemr/openemr/issues/7814))
-  cannot delete from address book when username is null ([#7805](https://github.com/openemr/openemr/issues/7805))
-  cannot view fee sheet items if billing.billed is null ([#7807](https://github.com/openemr/openemr/issues/7807))
-  prior auth module broken patient report link ([#7803](https://github.com/openemr/openemr/issues/7803))
-  report pdf error with faxsms module installed ([#7793](https://github.com/openemr/openemr/issues/7793))


### OpenEMR Developer Changes

### Fixed
-  Clinical Decisions Rule review screen has invalid CSRF class used ([#7832](https://github.com/openemr/openemr/issues/7832))

## [7.0.2.2](https://github.com/openemr/openemr/milestone/14?closed=1) - 2024-10-25

### Added
  -  Change Patient Portal Layout to use tile format for mobile friendly design ([#7609](https://github.com/openemr/openemr/issues/7609))
  -  Change Patient Portal Request New Appointment Openings Label to See Availability ([#7654](https://github.com/openemr/openemr/issues/7654))
  -  Convert portal_patient_report.php file to  use twig template for module writers to extend ([#7707](https://github.com/openemr/openemr/issues/7707))
  -  Improve Portal Credential Settings page for patients ([#7650](https://github.com/openemr/openemr/issues/7650))
  -  Improve asset config to support html script tags of type module for javascript module support ([#7698](https://github.com/openemr/openemr/issues/7698))
  -  Improve patient and clinician message user interface ([#7648](https://github.com/openemr/openemr/issues/7648))
  -  Patient Portal Download Medical Record Documents make file path easier to distinguish and download help message. ([#7660](https://github.com/openemr/openemr/issues/7660))
  -  Patient Portal allow new appointments to choose dates in localized format ([#7608](https://github.com/openemr/openemr/issues/7608))
  -  Patient portal demographics make save action mobile friendly ([#7656](https://github.com/openemr/openemr/issues/7656))
  -  Patient portal show single page app page title when page navigation changes ([#7646](https://github.com/openemr/openemr/issues/7646))
  -  Portal appointments request should not allow No Show appointment type to be selected ([#7640](https://github.com/openemr/openemr/issues/7640))
  -  Prescription Email Feature ([#7480](https://github.com/openemr/openemr/issues/7480))
  -  Send Prescription Email using Webclient/Native mail program ([#7494](https://github.com/openemr/openemr/issues/7494))
  -  Twigify patient portal appointments card list and show clearer message when no appointments are found. ([#7652](https://github.com/openemr/openemr/issues/7652))
  -  Twigify the patient portal Digital Signature page for module writers ([#7658](https://github.com/openemr/openemr/issues/7658))
  -  Update EHI documentation to include FHIR _lastUpdated columns  ([#7764](https://github.com/openemr/openemr/issues/7764))
  -  Update Pull Request Template to provide documentation for AI Generated Code ([#7705](https://github.com/openemr/openemr/issues/7705))
  -  Warn user when attempting prescription fax if signature is not configured ([#7525](https://github.com/openemr/openemr/issues/7525))
  -  allow embedding of lform javascript/style questionnaire files using the setupHeader syntax ([#7699](https://github.com/openemr/openemr/issues/7699))
  -  allow patients with 1 character first name ([#7714](https://github.com/openemr/openemr/issues/7714))
  -  change clinical messages casing in messages.php ([#7644](https://github.com/openemr/openemr/issues/7644))
  -  upgrade 2025 icd10 ([#7712](https://github.com/openemr/openemr/issues/7712))


### Fixed
  - Add back faxsms Module RingCentral Support ([#7541](https://github.com/openemr/openemr/issues/7541))
  - Add title to all appointment sql queries ([#7311](https://github.com/openemr/openemr/pull/7311))
  - Adding module manager ([#7500](https://github.com/openemr/openemr/pull/7500))
  - Billing Manager and Some Module fixes ([#7747](https://github.com/openemr/openemr/pull/7747))
  - Billing Manager showing unassigned ([#7553](https://github.com/openemr/openemr/issues/7553))
  - Bug fixes for nation notes, lbf ([#6740](https://github.com/openemr/openemr/pull/6740))
  - Bug openemr fix 7746 export since delta fix ([#7754](https://github.com/openemr/openemr/pull/7754))
  - CCDA Service compile is broken node version > v18.x ([#7528](https://github.com/openemr/openemr/issues/7528))
  - CKEditor4 now throwing security popup ([#7540](https://github.com/openemr/openemr/issues/7540))
  - Change telehealth support contact ([#7560](https://github.com/openemr/openemr/issues/7560))
  - Dorn Changes ([#7221](https://github.com/openemr/openemr/pull/7221))
  - Eligibility Fixes ([#7774](https://github.com/openemr/openemr/pull/7774))
  - Encounter Review shows unknown in tab title. ([#7776](https://github.com/openemr/openemr/issues/7776))
  - Fax No Content error ([#7505](https://github.com/openemr/openemr/issues/7505))
  - Fax/SMS Weno modules needs updates and bug fixes. ([#7696](https://github.com/openemr/openemr/issues/7696))
  - Fixes #7503 user admin create empty google sign in ([#7504](https://github.com/openemr/openemr/pull/7504))
  - LBF deletes newly added service when diagnoses already saved ([#7579](https://github.com/openemr/openemr/issues/7579))
  - List Edit has a save limit of 40 ([#7694](https://github.com/openemr/openemr/issues/7694))
  - Module command line batch notifications broken. ([#7752](https://github.com/openemr/openemr/issues/7752))
  - More Changes and Fixes Modules ([#7755](https://github.com/openemr/openemr/pull/7755))
  - Need module bootstrap status events ([#7462](https://github.com/openemr/openemr/issues/7462))
  - New Fixes ([#7770](https://github.com/openemr/openemr/pull/7770))
  - ONC certification requires removal of 2015 wording ([#7690](https://github.com/openemr/openemr/issues/7690))
  - Patient menu navigation not working when Prior Auth module enabled ([#7677](https://github.com/openemr/openemr/issues/7677))
  - Payor never being returned in FHIR Coverage endpoint ([#7684](https://github.com/openemr/openemr/issues/7684))
  - Portal create new appointment is broken ([#7688](https://github.com/openemr/openemr/issues/7688))
  - Portal document display  ([#7632](https://github.com/openemr/openemr/issues/7632))
  - Portal patient documents download broken ([#7692](https://github.com/openemr/openemr/issues/7692))
  - Portal updates and bug fixes ([#7599](https://github.com/openemr/openemr/issues/7599))
  - Prevent Appointment comment as visit reason ([#7680](https://github.com/openemr/openemr/issues/7680))
  - Prior Authorizations Report Error. #7461 ([#7558](https://github.com/openemr/openemr/issues/7558))
  - Questionnaire - configure where LOINC terms note is displayed ([#7550](https://github.com/openemr/openemr/issues/7550))
  - Repair OA Eligibility  ([#7773](https://github.com/openemr/openemr/issues/7773))
  - Replace CkEditor  Nation Notes and Portal ([#7544](https://github.com/openemr/openemr/issues/7544))
  - Replace ckeditor in portal ([#7594](https://github.com/openemr/openemr/issues/7594))
  - Template access from Demographics several issues ([#7758](https://github.com/openemr/openemr/issues/7758))
  - Update FHIR LForms to latest version v36.3.3 and restyle form rendering. ([#7666](https://github.com/openemr/openemr/issues/7666))
  - Wrong insurance information displayed when attempting to update ([#7763](https://github.com/openemr/openemr/issues/7763))
  -  'None' does not hide 'search by any demographics' field ([#7493](https://github.com/openemr/openemr/issues/7493))
  -  Bulk export _since parameter is throwing error ([#7746](https://github.com/openemr/openemr/issues/7746))
  -  Calendar entries when comments are turned on show html for escaped characters ([#7635](https://github.com/openemr/openemr/issues/7635))
  -  Create users breaks when more than one user has an empty email address for Google Email For Login ([#7503](https://github.com/openemr/openemr/issues/7503))
  -  Custom Reports-Superbill not showing Billing Information ([#7581](https://github.com/openemr/openemr/issues/7581))
  -  Document Uploader when editing document properties shows a stray html tag on success message ([#7511](https://github.com/openemr/openemr/issues/7511))
  -  EncounterService uses referring provider id for therapy_group name on insert ([#7569](https://github.com/openemr/openemr/issues/7569))
  -  Insurance coverage save fails for payer relationship self when subscriber name has different casing ([#7477](https://github.com/openemr/openemr/issues/7477))
  -  Lab Core Procedure Manual eReq breaks due to PHP8 date issue if date_collected is not filled in ([#7526](https://github.com/openemr/openemr/issues/7526))
  -  Patient Portal Secure Messaging checkbox click should select item instead of open for reading ([#7662](https://github.com/openemr/openemr/issues/7662))
  -  Patient Portal appointment shows "error" screen for patient's first appointment ([#7633](https://github.com/openemr/openemr/issues/7633))
  -  Prescription Fax fails when signature file is populated on PHP8 ([#7524](https://github.com/openemr/openemr/issues/7524))
  -  Questionnaire throws error in clinical documents page if validation fails due to translation failure ([#7621](https://github.com/openemr/openemr/issues/7621))
  -  Show Visit Category option on Encounters, Hide on New and Edit Form ([#7686](https://github.com/openemr/openemr/issues/7686))
  -  Skip payment scripts in portal if Portal Allow Online Payments feature disabled. ([#7620](https://github.com/openemr/openemr/issues/7620))
  -  Upgrade to v702 fails for v301 ([#7630](https://github.com/openemr/openemr/issues/7630))
  -  User Admin screen 	Google Email for Login does not save when creating new user ([#7393](https://github.com/openemr/openemr/issues/7393))
  -  create custom temp directory for htmlpurify ([#7520](https://github.com/openemr/openemr/issues/7520))
  -  default x12 partner not selected in billing manager ([#7501](https://github.com/openemr/openemr/issues/7501))
  -  editing insurance company from practice settings 404 not found ([#7483](https://github.com/openemr/openemr/issues/7483))
  -  export to collections fails to send all encounters for a person ([#7768](https://github.com/openemr/openemr/issues/7768))
  -  fix variable typo in messages.php ([#7467](https://github.com/openemr/openemr/issues/7467))
  -  getEffectiveInsurances not inspecting date_end  ([#7489](https://github.com/openemr/openemr/issues/7489))
  -  jquery-datetimepicker-2-5-4-translated.js creates invalid date format when DateFormatRead is not in window scope ([#7497](https://github.com/openemr/openemr/issues/7497))
  -  migrate table engine array binds ([#7565](https://github.com/openemr/openemr/issues/7565))
  -  patient portal secure messaging timing issue. Messages sometimes are unclickable in inbox when page loads. ([#7663](https://github.com/openemr/openemr/issues/7663))
  -  portal htmlpurify serializer path not writable ([#7475](https://github.com/openemr/openemr/issues/7475))
  -  typo in 837I script ([#7468](https://github.com/openemr/openemr/issues/7468))
  -  webroot typo documents-go portal home ([#7473](https://github.com/openemr/openemr/issues/7473))
  -  x12837 billing 5 or 9 digit zip check ([#7759](https://github.com/openemr/openemr/issues/7759))
  - configure two logos on the portal login page - as one can on user login page ([#7710](https://github.com/openemr/openemr/issues/7710))
  - issue type not shown in encounter add issue form ([#7563](https://github.com/openemr/openemr/issues/7563))
  - search by any demographic configured as fixed doesn't use patient finder ([#7596](https://github.com/openemr/openemr/issues/7596))


### Changed
  -  Input sanitation on google signin email ([#7356](https://github.com/openemr/openemr/pull/7356))
  -  bug ([#7535](https://github.com/openemr/openemr/pull/7535))
  -  send each checked encounter to collections in form export ([#7769](https://github.com/openemr/openemr/pull/7769))
  -  x12837 billing 5 or 9 digit zip check ([#7760](https://github.com/openemr/openemr/pull/7760))
  -  x12837 billing 5 or 9 digit zip check (#7760) for rel-702 ([#7765](https://github.com/openemr/openemr/pull/7765))


### OpenEMR Developer Changes

### Added
  -  Convert Dicom Viewer to Twig for Module writers to extend / overwrite ([#7509](https://github.com/openemr/openemr/issues/7509))
  -  Prescriptions Dialog move to twig to allow module writers to extend / modify the view ([#7496](https://github.com/openemr/openemr/issues/7496))
  -  pull patient portal health snapshot into modular twig/filter event for customization ([#7708](https://github.com/openemr/openemr/issues/7708))


### Changed
  -  Move patient previous name methods in patient service into its own Service ([#7568](https://github.com/openemr/openemr/issues/7568))


## [7.0.2.1](https://github.com/openemr/openemr/milestone/13?closed=1) - 2024-05-28

### Added
  -  Change Module Manager ([#7247](https://github.com/openemr/openemr/issues/7247))
  -  Encounter and observation report generation in Patient List Creation ([#7014](https://github.com/openemr/openemr/issues/7014))
  -  Etherfax need tiff image support and image to PDF ([#7436](https://github.com/openemr/openemr/issues/7436))
  -  Hide cards in the patient dashboard ([#7191](https://github.com/openemr/openemr/issues/7191))
  -  Modernize Work School Note ([#6946](https://github.com/openemr/openemr/issues/6946))
  -  Password strength meter missing ([#7366](https://github.com/openemr/openemr/issues/7366))
  -  Patient Insurance Policy rest endpoint for updating a specific policy  ([#7143](https://github.com/openemr/openemr/issues/7143))
  -  Show group attendance in encounter summary ([#7127](https://github.com/openemr/openemr/issues/7127))
  -  Weno EZ Integration ([#6635](https://github.com/openemr/openemr/issues/6635))
  -  Weno improve design, and pharmacy import speed ([#7204](https://github.com/openemr/openemr/pull/7204))
  -  When google single sign on is enabled it still requires user to use password from openEMR to sign the encounter doesn't use single sign on. ([#7254](https://github.com/openemr/openemr/issues/7254))
  -  add Real World Testing Report for 2024 ([#7210](https://github.com/openemr/openemr/pull/7210))
  -  electronically post payment when billed modifier isn't returned in ERA ([#7293](https://github.com/openemr/openemr/issues/7293))
  -  improved pharmacy download, user facility selection improvement,  improved UX for errors and theme compatability ([#7208](https://github.com/openemr/openemr/pull/7208))
  -  make Demographics Insurance Edit Screen its own page ([#7108](https://github.com/openemr/openemr/issues/7108))
  -  show collection balance in billing widget ([#7454](https://github.com/openemr/openemr/pull/7454))
  -  support 2024 reporting cqm valueset import ([#7317](https://github.com/openemr/openemr/issues/7317))
  -  support electronic worker's comp claims ([#7206](https://github.com/openemr/openemr/issues/7206))
  -  total front receipts by payment method ([#7448](https://github.com/openemr/openemr/issues/7448))
  -  use default visit category in add edit event ([#7189](https://github.com/openemr/openemr/issues/7189))
  -  weno changes - restrict NCPDPD to 7 digits per spec ([#7384](https://github.com/openemr/openemr/pull/7384))


### Fixed
  - Backport etherfax #7429 #7447 ([#7452](https://github.com/openemr/openemr/pull/7452))
  - Gap cherry-picks ([#7451](https://github.com/openemr/openemr/pull/7451))
  - Patch1 more cherry-picks ([#7457](https://github.com/openemr/openemr/pull/7457))
  - Phantom date showing at the top of all reports. ([#7433](https://github.com/openemr/openemr/pull/7433))
  - Prevent Upload of ZIP bombs ([#7407](https://github.com/openemr/openemr/pull/7407))
  - Pull request #7442 backport Cleanup Background tasks ([#7455](https://github.com/openemr/openemr/pull/7455))
  -  837P service location details are not created when service facility and billing facility differ ([#7213](https://github.com/openemr/openemr/issues/7213))
  -  Add previous name doesn't save New/Search ([#7437](https://github.com/openemr/openemr/issues/7437))
  -  Authentication Error when opening a patient with Open in New Browser Tab checked. ([#7167](https://github.com/openemr/openemr/issues/7167))
  -  Billing Manager Date of Service selector not working ([#7069](https://github.com/openemr/openemr/issues/7069))
  -  CDR gui summary screen submit breaks when set no alert types ([#7178](https://github.com/openemr/openemr/issues/7178))
  -  CDR reminder_results_integrate() to work when same actions are used in different rules ([#7266](https://github.com/openemr/openemr/issues/7266))
  -  Cannot delete entry from immunization list ([#7345](https://github.com/openemr/openemr/issues/7345))
  -  Claimrev leaves background service on when module is uninstalled ([#7441](https://github.com/openemr/openemr/issues/7441))
  -  Clinical Rules - dates and filters ([#7157](https://github.com/openemr/openemr/issues/7157))
  -  Clinical Rules - interval boundaries used in evaluating target instances ([#7161](https://github.com/openemr/openemr/issues/7161))
  -  Clinical Rules - logic issues in filter and target evaluations; divide by zero bug ([#7153](https://github.com/openemr/openemr/issues/7153))
  -  Eye Form Style fixes ([#7051](https://github.com/openemr/openemr/pull/7051))
  -  File missing for Quest Lab Hub to function properly ([#7084](https://github.com/openemr/openemr/issues/7084))
  -  Fixes bugs in user edit screen, restyle Logs Viewer ([#7222](https://github.com/openemr/openemr/pull/7222))
  -  In Visit History, print, or save as PDF, a multi-page list of encounters doesn't print or save all results. ([#7270](https://github.com/openemr/openemr/issues/7270))
  -  Insurance Edit Screen overwrites insurance fax value ([#7164](https://github.com/openemr/openemr/issues/7164))
  -  Insurance Edit screen add provider functionality does not update provider list ([#7109](https://github.com/openemr/openemr/issues/7109))
  -  Insurance rest endpoints documentation incorrect for patient pid  ([#7145](https://github.com/openemr/openemr/issues/7145))
  -  Layout Based Forms (LBF) printable fatal error ([#7148](https://github.com/openemr/openemr/issues/7148))
  -  Layout Based Forms (LBF) query error breaks on newer database versions ([#7239](https://github.com/openemr/openemr/issues/7239))
  -  Messages SMS Zone Combobox width ([#6070](https://github.com/openemr/openemr/issues/6070))
  -  Missing Pdf and Track Anything style sheets ([#7258](https://github.com/openemr/openemr/issues/7258))
  -  OpenEMR logs sensitive field - payment reference number ([#7340](https://github.com/openemr/openemr/issues/7340))
  -  OpenEMR\Service\BaseService->getSelectJoinClauses() join_clause property is improperly escaped ([#7188](https://github.com/openemr/openemr/issues/7188))
  -  Opening portal templates from documents broken ([#7173](https://github.com/openemr/openemr/issues/7173))
  -  Patient Insurance List All Endpoint fails ([#7107](https://github.com/openemr/openemr/issues/7107))
  -  Practice Settings Insurance Company list extremely slow to load with hundreds of insurance companies ([#7224](https://github.com/openemr/openemr/issues/7224))
  -  SNOMED lookup is slow in some places ([#7276](https://github.com/openemr/openemr/issues/7276))
  -  Unable to import CCDA XML files in Docker 7.0.3 ([#7411](https://github.com/openemr/openemr/issues/7411))
  -  Unable to share templates in nations note ([#7129](https://github.com/openemr/openemr/issues/7129))
  -  User able to select a Date of Birth that occurs in the future on new patient screen ([#7378](https://github.com/openemr/openemr/issues/7378))
  -  Weno calculate age bug and labels incorrectly used for weno user ([#7453](https://github.com/openemr/openemr/pull/7453))
  -  [CKEDITOR] Error code: invalid-lts-license-key. ([#7097](https://github.com/openemr/openemr/issues/7097))
  -  appointments report total incorrect ([#7289](https://github.com/openemr/openemr/issues/7289))
  -  balance formatting in record front payment ([#7260](https://github.com/openemr/openemr/issues/7260))
  -  billing manager To Encounter button doesn't load proper person for insurance edit  ([#7419](https://github.com/openemr/openemr/issues/7419))
  -  billing manager broken validation of claim with replaced patient insurance ([#7263](https://github.com/openemr/openemr/issues/7263))
  -  billing_note duplication each time invoice form is saved ([#7287](https://github.com/openemr/openemr/issues/7287))
  -  document display fail on empty array key ([#7390](https://github.com/openemr/openemr/issues/7390))
  -  encounter date of service time format ([#7202](https://github.com/openemr/openemr/issues/7202))
  -  era posting denial write off ([#7186](https://github.com/openemr/openemr/issues/7186))
  -  escaping custom templates used with ckeditor ([#7151](https://github.com/openemr/openemr/issues/7151))
  -  etherFax fails render on large download log. ([#7430](https://github.com/openemr/openemr/issues/7430))
  -  eye exam chart fails since upgrade to latest chart.js package ([#7155](https://github.com/openemr/openemr/issues/7155))
  -  fatal implode error registering app when contacts is empty ([#7282](https://github.com/openemr/openemr/issues/7282))
  -  fix bug ([#7231](https://github.com/openemr/openemr/pull/7231))
  -  fix bug ([#7229](https://github.com/openemr/openemr/pull/7229))
  -  fix jspdf versions from PR#7429 ([#7447](https://github.com/openemr/openemr/pull/7447))
  -  need to handle multiple modifiers in fee sheet ([#7165](https://github.com/openemr/openemr/issues/7165))
  -  not_due not working in the Clinical Reminders widget ([#7200](https://github.com/openemr/openemr/issues/7200))
  -  pdf download patient report ([#7053](https://github.com/openemr/openemr/issues/7053))
  -  php fatal math error when saving empty statement count editing invoice ([#7280](https://github.com/openemr/openemr/issues/7280))
  -  rel_702 form_encounter missing last_update field ([#7183](https://github.com/openemr/openemr/issues/7183))
  -  saving `# of tablets` in a prescription to `9999999999` sets it to `2147483647` ([#7314](https://github.com/openemr/openemr/issues/7314))
  -  saving existing insurance with no country in address ([#7331](https://github.com/openemr/openemr/issues/7331))
  -  visit history count for display of ALL results incorrect, if shorter pages displayed previously ([#7385](https://github.com/openemr/openemr/issues/7385))


### Changed
  -  to not allow user to pick future date for DOB ([#7379](https://github.com/openemr/openemr/pull/7379))
  -  replace htmlspecialchars with escaping functions for recent commit ([#7146](https://github.com/openemr/openemr/pull/7146))
  -  Nation Notes components display breaks when building a list of components. ([#7176](https://github.com/openemr/openemr/issues/7176))
  -  batch payments distinct tab ([#7398](https://github.com/openemr/openemr/pull/7398))
  -  billing manager To Encounter button to load proper person ([#7420](https://github.com/openemr/openemr/pull/7420))
  -  bug ([#7435](https://github.com/openemr/openemr/pull/7435))
  -  bug ([#7434](https://github.com/openemr/openemr/pull/7434))
  -  bug fix ([#7230](https://github.com/openemr/openemr/pull/7230))
  -  bug fix for rel-702 ([#7193](https://github.com/openemr/openemr/pull/7193))
  -  cdr fix to correctly show actions that are due, due soon, past due in expanded listings ([#7211](https://github.com/openemr/openemr/pull/7211))


### OpenEMR Developer Changes

### Added
  -  Add module perform after actions functionality to Module Manager ([#7147](https://github.com/openemr/openemr/issues/7147))
  -  Add to SMART style twig files the OpenEMR logo and populate the modal backdrop color ([#7134](https://github.com/openemr/openemr/issues/7134))
  -  Add zipcode plus_four to address service / apis ([#7216](https://github.com/openemr/openemr/issues/7216))
  -  Allow module writers to add commands to the bin/console command runner ([#7237](https://github.com/openemr/openemr/issues/7237))
  -  Enhance BaseService->getSelectFields to support table and column aliases ([#7370](https://github.com/openemr/openemr/issues/7370))
  -  Extract billing code selector logic from options.inc.php into its own class ([#7323](https://github.com/openemr/openemr/issues/7323))
  -  Extract local providers list selector logic from options.inc.php into its own class ([#7368](https://github.com/openemr/openemr/issues/7368))
  -  FHIR Patient missing deceasedBoolean ([#7063](https://github.com/openemr/openemr/issues/7063))
  -  FHIR ValueSet is missing ([#7062](https://github.com/openemr/openemr/issues/7062))
  -  Infrastructure to send documents to cloud storage buckets ([#7232](https://github.com/openemr/openemr/issues/7232))
  -  Insurance Company Service allow setting id and make phone settings optional ([#7217](https://github.com/openemr/openemr/issues/7217))
  -  Time format in logs should display seconds instead of just hours and minutes ([#7335](https://github.com/openemr/openemr/issues/7335))
  -  Title is not returned when getting list of Appointments via API. ([#7301](https://github.com/openemr/openemr/issues/7301))
  -  Twigify Portal Quick Start landing page. Prep for plugin support. ([#7116](https://github.com/openemr/openemr/issues/7116))
  -  User settings not set if not in globals. ([#7194](https://github.com/openemr/openemr/issues/7194))
  -  minor CryptoGen class updates ([#7365](https://github.com/openemr/openemr/pull/7365))


### Fixed
  -  Adding calendar event (appointment) via API causes endTime to be set to 0:00:00 ([#7300](https://github.com/openemr/openemr/issues/7300))
  -  CCDA import creates extra entries in list_options for drug_units list_id ([#7319](https://github.com/openemr/openemr/issues/7319))
  -  Duplicated "extends" key in stylelint configuration file ([#6700](https://github.com/openemr/openemr/issues/6700))
  -  FHIR Appointment fields wrong or missing ([#7061](https://github.com/openemr/openemr/issues/7061))
  -  FHIR Encounter lastUpdated field is wrong and missing as search param ([#7064](https://github.com/openemr/openemr/issues/7064))
  -  InstallerController needs to pass current status to ModuleManagerAfterActionListener action methods ([#7214](https://github.com/openemr/openemr/issues/7214))
  -  Insurance Company Service does not load records that have no address entry ([#7226](https://github.com/openemr/openemr/issues/7226))
  -  PatientValidator email address should not fail to validate with empty string "" for email ([#7219](https://github.com/openemr/openemr/issues/7219))
  -  SMART on FHIR style url is throwing 500 error. ([#7133](https://github.com/openemr/openemr/issues/7133))
  -  SectionEvent->addCard append places second function call in first index position ([#7171](https://github.com/openemr/openemr/issues/7171))
  -  Trusted Email is missing from FHIR Patient ([#7113](https://github.com/openemr/openemr/issues/7113))
  -  ccda import fails on empty postParseEvent ([#7347](https://github.com/openemr/openemr/issues/7347))
  -  missing use aclmain statement in prior commit ([#7427](https://github.com/openemr/openemr/issues/7427))


### Changed
  -  bump phpseclib/phpseclib from 3.0.34 to 3.0.36 ([#7259](https://github.com/openemr/openemr/pull/7259))
  -  ci add mariadb 11.3, change mysql 8.2 to mysql 8.3 ([#7273](https://github.com/openemr/openemr/pull/7273))
  -  commit 2 that updates github actions for docker builds to prevent deprecations ([#7272](https://github.com/openemr/openemr/pull/7272))
  -  update github actions for docker builds to prevent deprecations ([#7271](https://github.com/openemr/openemr/pull/7271))
  -  possible fix of logic in jquery-datetimepicker-2-5-4-translated.js ([#7223](https://github.com/openemr/openemr/pull/7223))

## [7.0.2.1](https://github.com/openemr/openemr/milestone/13?closed=1) - 2024-04-26

### Added
  -  Add to SMART style twig files the OpenEMR logo and populate the modal backdrop color ([#7134](https://github.com/openemr/openemr/issues/7134))
  -  Add zipcode plus_four to address service / apis ([#7216](https://github.com/openemr/openemr/issues/7216))
  -  Allow module writers to add commands to the bin/console command runner ([#7237](https://github.com/openemr/openemr/issues/7237))
  -  Encounter and observation report generation in Patient List Creation ([#7014](https://github.com/openemr/openemr/issues/7014))
  -  Enhance BaseService->getSelectFields to support table and column aliases ([#7370](https://github.com/openemr/openemr/issues/7370))
  -  Extract billing code selector logic from options.inc.php into its own class ([#7323](https://github.com/openemr/openemr/issues/7323))
  -  Extract local providers list selector logic from options.inc.php into its own class ([#7368](https://github.com/openemr/openemr/issues/7368))
  -  FHIR Patient missing deceasedBoolean ([#7063](https://github.com/openemr/openemr/issues/7063))
  -  FHIR ValueSet is missing ([#7062](https://github.com/openemr/openemr/issues/7062))
  -  Infrastructure to send documents to cloud storage buckets ([#7232](https://github.com/openemr/openemr/issues/7232))
  -  Insurance Company Service allow setting id and make phone settings optional ([#7217](https://github.com/openemr/openemr/issues/7217))
  -  Modernize Work School Note ([#6946](https://github.com/openemr/openemr/issues/6946))
  -  Password strength meter missing ([#7366](https://github.com/openemr/openemr/issues/7366))
  -  Patient Insurance Policy rest endpoint for updating a specific policy  ([#7143](https://github.com/openemr/openemr/issues/7143))
  -  Refactor Demographics Insurance Edit Screen ([#7108](https://github.com/openemr/openemr/issues/7108))
  -  Title is not returned when getting list of Appointments via API. ([#7301](https://github.com/openemr/openemr/issues/7301))
  -  add Real World Testing Report for 2024 ([#7210](https://github.com/openemr/openemr/pull/7210))
  -  electronically post payment when billed modifier isn't returned in ERA ([#7293](https://github.com/openemr/openemr/issues/7293))
  -  minor CryptoGen class updates ([#7365](https://github.com/openemr/openemr/pull/7365))
  -  support 2024 reporting cqm valueset import ([#7317](https://github.com/openemr/openemr/issues/7317))
  -  support electronic worker's comp claims ([#7206](https://github.com/openemr/openemr/issues/7206))
  -  use default visit category in add edit event ([#7189](https://github.com/openemr/openemr/issues/7189))


### Fixed
  - Add module perform after actions functionality to Module Manager ([#7147](https://github.com/openemr/openemr/issues/7147))
  - Authentication Error when opening a patient with Open in New Browser Tab checked. ([#7167](https://github.com/openemr/openemr/issues/7167))
  - CDR gui summary screen submit breaks when set no alert types ([#7178](https://github.com/openemr/openemr/issues/7178))
  - Change Module Manager ([#7247](https://github.com/openemr/openemr/issues/7247))
  - Eye Form Style fixes ([#7051](https://github.com/openemr/openemr/pull/7051))
  - Missing Pdf and Track Anything style sheets ([#7258](https://github.com/openemr/openemr/issues/7258))
  - Nation Notes components render broken. ([#7176](https://github.com/openemr/openemr/issues/7176))
  - Opening portal templates from documents broken ([#7173](https://github.com/openemr/openemr/issues/7173))
  - SNOMED lookup is slow in some places ([#7276](https://github.com/openemr/openemr/issues/7276))
  - Saving `# of tablets` in a prescription to `9999999999` sets it to `2147483647` ([#7314](https://github.com/openemr/openemr/issues/7314))
  - Show group attendance in encounter summary ([#7127](https://github.com/openemr/openemr/issues/7127))
  - Trusted Email is missing from FHIR Patient ([#7113](https://github.com/openemr/openemr/issues/7113))
  - Various Bug fixes. ([#7222](https://github.com/openemr/openemr/pull/7222))
  - Weno EZ Integration ([#6635](https://github.com/openemr/openemr/issues/6635))
  - Weno fixes and updates ([#7204](https://github.com/openemr/openemr/pull/7204))
  - Weno module changes ([#7208](https://github.com/openemr/openemr/pull/7208))
  - When google single sign on is enabled it still requires user to use password from openEMR to sign the encounter doesn't use single sign on. ([#7254](https://github.com/openemr/openemr/issues/7254))
  - appointments report total incorrect ([#7289](https://github.com/openemr/openemr/issues/7289))
  - billing_note duplication ([#7287](https://github.com/openemr/openemr/issues/7287))
  -  837P service location details are not created when service facility and billing facility differ ([#7213](https://github.com/openemr/openemr/issues/7213))
  -  Billing Manager Date of Service selector not working ([#7069](https://github.com/openemr/openemr/issues/7069))
  -  CCDA import creates extra entries in list_options for drug_units list_id ([#7319](https://github.com/openemr/openemr/issues/7319))
  -  Clinical Rules - dates and filters ([#7157](https://github.com/openemr/openemr/issues/7157))
  -  Clinical Rules - interval boundaries used in evaluating target instances ([#7161](https://github.com/openemr/openemr/issues/7161))
  -  Clinical Rules - several fixes ([#7153](https://github.com/openemr/openemr/issues/7153))
  -  Duplicated "extends" key in stylelint configuration file ([#6700](https://github.com/openemr/openemr/issues/6700))
  -  FHIR Appointment fields wrong or missing ([#7061](https://github.com/openemr/openemr/issues/7061))
  -  FHIR Encounter lastUpdated field is wrong and missing as search param ([#7064](https://github.com/openemr/openemr/issues/7064))
  -  File missing for Quest Lab Hub to function properly ([#7084](https://github.com/openemr/openemr/issues/7084))
  -  In Visit History, print, or save as PDF, a multi-page list of encounters doesn't print or save all results. ([#7270](https://github.com/openemr/openemr/issues/7270))
  -  Inadequate time format in logs ([#7335](https://github.com/openemr/openemr/issues/7335))
  -  InstallerController needs to pass current status to ModuleManagerAfterActionListener action methods ([#7214](https://github.com/openemr/openemr/issues/7214))
  -  Insurance Company Service does not load records that have no address entry ([#7226](https://github.com/openemr/openemr/issues/7226))
  -  Insurance Edit Add Provider Does Not Update Provider List ([#7109](https://github.com/openemr/openemr/issues/7109))
  -  Insurance Edit Screen overwrites insurance fax value ([#7164](https://github.com/openemr/openemr/issues/7164))
  -  Insurance rest endpoints documentation incorrect for patient pid  ([#7145](https://github.com/openemr/openemr/issues/7145))
  -  LBF printable fatal error ([#7148](https://github.com/openemr/openemr/issues/7148))
  -  LBF query error ([#7239](https://github.com/openemr/openemr/issues/7239))
  -  Messages SMS Zone Combobox width ([#6070](https://github.com/openemr/openemr/issues/6070))
  -  OpenEMR\Service\BaseService->getSelectJoinClauses() join_clause property is improperly escaped ([#7188](https://github.com/openemr/openemr/issues/7188))
  -  Patient Insurance List All Endpoint fails ([#7107](https://github.com/openemr/openemr/issues/7107))
  -  PatientValidator email address should not fail to validate with empty string "" for email ([#7219](https://github.com/openemr/openemr/issues/7219))
  -  Practice Settings Insurance Company list extremely slow to load with hundreds of insurance companies ([#7224](https://github.com/openemr/openemr/issues/7224))
  -  SMART on FHIR style url is throwing 500 error. ([#7133](https://github.com/openemr/openemr/issues/7133))
  -  SectionEvent->addCard append places second function call in first index position ([#7171](https://github.com/openemr/openemr/issues/7171))
  -  Unable to share templates in nations note ([#7129](https://github.com/openemr/openemr/issues/7129))
  -  balance formatting in front payment ([#7260](https://github.com/openemr/openemr/issues/7260))
  -  broken validation of claim with replaced insurance ([#7263](https://github.com/openemr/openemr/issues/7263))
  -  ccda import fails on empty postParseEvent ([#7347](https://github.com/openemr/openemr/issues/7347))
  -  document display fail on empty array key ([#7390](https://github.com/openemr/openemr/issues/7390))
  -  era posting denial write off ([#7186](https://github.com/openemr/openemr/issues/7186))
  -  escaping custom templates used with ckeditor ([#7151](https://github.com/openemr/openemr/issues/7151))
  -  eye exam chart fails since upgrade to latest chart.js package ([#7155](https://github.com/openemr/openemr/issues/7155))
  -  fatal implode error registering app when contacts is empty ([#7282](https://github.com/openemr/openemr/issues/7282))
  -  fix bug ([#7231](https://github.com/openemr/openemr/pull/7231))
  -  fix bug ([#7229](https://github.com/openemr/openemr/pull/7229))
  -  multiple modifiers in fee sheet ([#7165](https://github.com/openemr/openemr/issues/7165))
  -  pdf download patient report ([#7053](https://github.com/openemr/openemr/issues/7053))
  -  php fatal math error when saving empty statement count editing invoice ([#7280](https://github.com/openemr/openemr/issues/7280))
  -  rel_702 form_encounter missing last_update field ([#7183](https://github.com/openemr/openemr/issues/7183))
  -  saving existing insurance with no country in address ([#7331](https://github.com/openemr/openemr/issues/7331))
  - not_due not working in the Clinical Reminders widget ([#7200](https://github.com/openemr/openemr/issues/7200))
  - weno changes ([#7384](https://github.com/openemr/openemr/pull/7384))


### Changed
  - 00:00 ([#7300](https://github.com/openemr/openemr/issues/7300))
  -  OpenEMR logs sensitive information such as payment details ([#7340](https://github.com/openemr/openemr/issues/7340))
  -  invalid-lts-license-key. ([#7097](https://github.com/openemr/openemr/issues/7097))
  -  bump phpseclib/phpseclib from 3.0.34 to 3.0.36 ([#7259](https://github.com/openemr/openemr/pull/7259))
  -  ci add mariadb 11.3, change mysql 8.2 to mysql 8.3 ([#7273](https://github.com/openemr/openemr/pull/7273))
  -  commit 2 that updates github actions for docker builds to prevent deprecations ([#7272](https://github.com/openemr/openemr/pull/7272))
  -  replace htmlspecialchars with escaping functions for recent commit ([#7146](https://github.com/openemr/openemr/pull/7146))
  -  update github actions for docker builds to prevent deprecations ([#7271](https://github.com/openemr/openemr/pull/7271))
  -  bug fix ([#7230](https://github.com/openemr/openemr/pull/7230))
  -  bug fix for rel-702 ([#7193](https://github.com/openemr/openemr/pull/7193))
  -  cdr fix to correctly show actions that are due, due soon, past due in expanded listings ([#7211](https://github.com/openemr/openemr/pull/7211))
  -  possible fix of logic in jquery-datetimepicker-2-5-4-translated.js ([#7223](https://github.com/openemr/openemr/pull/7223))
  -  reminder_results_integrate() to work when same actions are used in different rules ([#7266](https://github.com/openemr/openemr/issues/7266))


### OpenEMR Developer Changes

### Fixed
  - Twigify Portal Quick Start landing page. Prep for plugin support. ([#7116](https://github.com/openemr/openemr/issues/7116))
  - User settings not set if not in globals. ([#7194](https://github.com/openemr/openemr/issues/7194))


## [7.0.2](https://github.com/openemr/openemr/milestone/12?closed=1) - 2023-11-17

### Added
-  2024 ICD10 update ([#6796](https://github.com/openemr/openemr/issues/6796))
-  Add a combined nationality with country list to Demographics Stats group ([#6891](https://github.com/openemr/openemr/issues/6891))
-  Add ability to prevent forced portal credential change ([#6813](https://github.com/openemr/openemr/issues/6813))
-  Add container, better rendering of header, space buttons on the patient encounter page. ([#6768](https://github.com/openemr/openemr/pull/6768))
-  Add global setting for Admins to configure patient portal credential force reset behavior ([#6824](https://github.com/openemr/openemr/pull/6824))
-  Add patient upload to portal with portal notifications ([#6704](https://github.com/openemr/openemr/issues/6704))
-  Allow In Collection for New Encounter Form to be hidden ([#6906](https://github.com/openemr/openemr/issues/6906))
-  Allow default date in new Clinical Note ([#6909](https://github.com/openemr/openemr/issues/6909))
-  Better spacing of additional code buttons on fee sheet ([#6790](https://github.com/openemr/openemr/pull/6790))
-  Care Plan UI Wider Textbox ([#6709](https://github.com/openemr/openemr/pull/6709))
-  Display recent last 10 most recent patients viewed by current user on patient finder ([#6641](https://github.com/openemr/openemr/pull/6641))
-  EHI Export - track anything and updated table documentation ([#6987](https://github.com/openemr/openemr/pull/6987))
-  Enhanced Default Open Tabs Options ([#6604](https://github.com/openemr/openemr/pull/6604))
-  Implement ONC 2015 Certification (b)(10) Electronic Health Information Export  ([#6945](https://github.com/openemr/openemr/issues/6945))
-  Improve UI and code of newpatient report.php ([#6748](https://github.com/openemr/openemr/issues/6748))
-  Improve clinical note report User Interface to be more content-focused instead of table based. ([#6802](https://github.com/openemr/openemr/pull/6802))
-  Improve the Facilities UI by moving addresses to pill based tab panel ([#6687](https://github.com/openemr/openemr/pull/6687))
-  Issues detail form improve form layout and guide the user to avoid scrolling and show most common fields ([#6664](https://github.com/openemr/openemr/issues/6664))
-  Limit OpenEMR core appearance themes to five to simplify both development and user choices. ([#6534](https://github.com/openemr/openemr/issues/6534))
-  MFA TOTP should display a seed code to enter into an application that does not use QR Codes ([#6839](https://github.com/openemr/openemr/issues/6839))
-  More encounter UI improvements ([#6794](https://github.com/openemr/openemr/pull/6794))
-  Nationality list refactor for uniqueness and refactor nationality layout for new list ([#6936](https://github.com/openemr/openemr/pull/6936))
-  Need a new demographic field for Preferred Name. ([#6726](https://github.com/openemr/openemr/issues/6726))
-  Patient Portal restyle for portrait mode, add select to auto save, and alert patient to unsaved edits in edit mode ([#6560](https://github.com/openemr/openemr/pull/6560))
-  Portal update landing page and use default OpenEMR style themes instead of custom portal style theme. ([#6523](https://github.com/openemr/openemr/issues/6523))
-  Quest Lab Hub module support ([#6941](https://github.com/openemr/openemr/pull/6941))
-  Remove old frameset settings for frames related globals ([#6462](https://github.com/openemr/openemr/pull/6462))
-  Reorganize MRD cards ([#6582](https://github.com/openemr/openemr/pull/6582))
-  Restyle front dashboard cards on patient demographics screen. ([#6883](https://github.com/openemr/openemr/issues/6883))
-  Slight main interface redesign & 7.0.2+ mobile friendly changes on provider login view ([#6460](https://github.com/openemr/openemr/issues/6460))
-  Support patient portal onetime login tokens ([#6786](https://github.com/openemr/openemr/pull/6786))
-  The client app should avoid re-authenticating during it’s launch within OpenEMR ([#6525](https://github.com/openemr/openemr/issues/6525))
-  ability to inactivate facilities that are no longer used ([#6585](https://github.com/openemr/openemr/issues/6585))
-  create a fee schedule table to store the fee schedules from various payers ([#6955](https://github.com/openemr/openemr/issues/6955))
-  expose valedictory in user admin and esign ([#6812](https://github.com/openemr/openemr/issues/6812))
-  fix no-useless-escape error (eslint) ([#6734](https://github.com/openemr/openemr/pull/6734))
-  invoices generated should be saved to pt documents ([#6950](https://github.com/openemr/openemr/issues/6950))
-  put request urls from x12 clearinghouse screens into globals for versatility ([#6913](https://github.com/openemr/openemr/issues/6913))


### Fixed
-   Fix typo in interface/usergroup/mfa_totp.php ([#6974](https://github.com/openemr/openemr/issues/6974))
-  "Show Title on Login" not working in OpenEMR 7.0.1 Patch 1 ([#6650](https://github.com/openemr/openemr/issues/6650))
-  5010 interchange control numbers are expected to be unique ([#6900](https://github.com/openemr/openemr/issues/6900))
-  Add Issue Does not refresh screen on save ([#7006](https://github.com/openemr/openemr/issues/7006))
-  Allergy card on MRD fails to render NKDA ([#6759](https://github.com/openemr/openemr/issues/6759))
-  ClaimRev Module problem in adding issues to encounter ([#6894](https://github.com/openemr/openemr/issues/6894))
-  Clinical Note Category does not respect Active setting ([#6907](https://github.com/openemr/openemr/issues/6907))
-  Clinical Note Type does not respect Active flag ([#6908](https://github.com/openemr/openemr/issues/6908))
-  Clinical reports are not filtering by diagnosis ([#6879](https://github.com/openemr/openemr/issues/6879))
-  Default themes font size to small ([#7027](https://github.com/openemr/openemr/issues/7027))
-  Demographics not rendering ([#6765](https://github.com/openemr/openemr/issues/6765))
-  Display oauth2 login error messages on login authorization page. ([#6845](https://github.com/openemr/openemr/issues/6845))
-  Divide By Zero Fatal Error if PAMI not authorized ([#6965](https://github.com/openemr/openemr/issues/6965))
-  EHI Export clinical notes form fixes and track anything implementation. ([#6985](https://github.com/openemr/openemr/pull/6985))
-  Emailing invoices broken ([#6711](https://github.com/openemr/openemr/issues/6711))
-  Encounter does not insert default POS from facility ([#6952](https://github.com/openemr/openemr/issues/6952))
-  Eye Form fails to load correctly. Requires update to eye_mag_functions.php ([#6807](https://github.com/openemr/openemr/pull/6807))
-  Facilities page active toggle button not styled correctly ([#6682](https://github.com/openemr/openemr/issues/6682))
-  Fix dependencies for core portal apps with dark styling theme ([#6555](https://github.com/openemr/openemr/pull/6555))
-  Fix undefined array key mod_relative_link and undefined php var closeAnchorClasses  ([#6976](https://github.com/openemr/openemr/pull/6976))
-  Form Pain Map fails to save w/ incorrect arguments error ([#6742](https://github.com/openemr/openemr/issues/6742))
-  Generate Demographic Widget/Cards from Modules - No custom function call in "btnLink" ([#6840](https://github.com/openemr/openemr/issues/6840))
-  Head Circumference is missing from the vitals display chart due to incorrect unit conversion ([#6527](https://github.com/openemr/openemr/issues/6527))
-  High severity allergies do not display with proper alarms ([#6662](https://github.com/openemr/openemr/issues/6662))
-  Highlight when using custom theme shows text colored pink due to hard coded style ([#6865](https://github.com/openemr/openemr/issues/6865))
-  Insufficient contrast when hovering over navbar in dark theme ([#6746](https://github.com/openemr/openemr/issues/6746))
-  Issue with medical_problem api ([#6988](https://github.com/openemr/openemr/issues/6988))
-  Lab requisition form does not work when connected orders are deleted  ([#6433](https://github.com/openemr/openemr/issues/6433))
-  Line breaks of text are not exporting as is when generating an xml/word document ([#6868](https://github.com/openemr/openemr/issues/6868))
-  Long Problem List leads to bad UI ([#6651](https://github.com/openemr/openemr/issues/6651))
-  MFA Management -> add new TOTP key gives blank screen. ([#6961](https://github.com/openemr/openemr/issues/6961))
-  MRD Portal Card does not respect global setting if portal and api are disabled ([#6653](https://github.com/openemr/openemr/issues/6653))
-  MRD top cards break if all 4 are rendered ([#6760](https://github.com/openemr/openemr/issues/6760))
-  Message doesn't allow assigned to user message display ([#6692](https://github.com/openemr/openemr/issues/6692))
-  Newcrop send only active diagnosis ([#6956](https://github.com/openemr/openemr/pull/6956))
-  Not all eligibilities were displaying in the ClaimRev module ([#6778](https://github.com/openemr/openemr/issues/6778))
-  On add new patient Previous name populates with wrong name ([#6769](https://github.com/openemr/openemr/issues/6769))
-  PHP 8 inventory lot edit error throws a fatal error when specifying the lot quantity. ([#6942](https://github.com/openemr/openemr/issues/6942))
-  Patient portal typo and translation in login page. ([#6714](https://github.com/openemr/openemr/pull/6714))
-  Portal documents corrupted on save. ([#6617](https://github.com/openemr/openemr/issues/6617))
-  Portal patient default document templates should recur always ([#6538](https://github.com/openemr/openemr/issues/6538))
-  Quest lab result should display specimen date ([#6917](https://github.com/openemr/openemr/issues/6917))
-  Quickfix to reverse the text and nl2br tags in newpatient forms ([#6793](https://github.com/openemr/openemr/pull/6793))
-  Remove hard coded gray background style in login page. ([#6920](https://github.com/openemr/openemr/issues/6920))
-  Summary screen user setting not presisting ([#7018](https://github.com/openemr/openemr/issues/7018))
-  Telehealth Transfer Appointment fails to launch appointment on latest 7.0.1 patch ([#6500](https://github.com/openemr/openemr/issues/6500))
-  Update mfa_totp.php to not show blank screen when user hits enter ([#6916](https://github.com/openemr/openemr/pull/6916))
-  add to list feature is broken ([#6484](https://github.com/openemr/openemr/issues/6484))
-  add/edit issue fails to update begin or end date to null datetime ([#6619](https://github.com/openemr/openemr/issues/6619))
-  address book and demographics contact referring providers with null username ([#6526](https://github.com/openemr/openemr/issues/6526))
-  alert on batch payments screen flashes off  ([#6717](https://github.com/openemr/openemr/issues/6717))
-  allergies appear when adding new patient with no issues ([#6724](https://github.com/openemr/openemr/issues/6724))
-  allergies are displayed with duplicates on upgrade to 7.0.2 due to missing user value in lists table ([#6930](https://github.com/openemr/openemr/issues/6930))
-  ambiguous facility id label ([#6963](https://github.com/openemr/openemr/issues/6963))
-  apostrophe breaks comment in save inside order results ([#6938](https://github.com/openemr/openemr/pull/6938))
-  appointments report lists canceled appointments ([#6546](https://github.com/openemr/openemr/issues/6546))
-  billing log isn't logging validate only well ([#6558](https://github.com/openemr/openemr/issues/6558))
-  calendar php8 fatal error in day, week, and month template views ([#6621](https://github.com/openemr/openemr/issues/6621))
-  default payment method checkout  ([#6564](https://github.com/openemr/openemr/issues/6564))
-  encounter pos code is saving when config option is disabled ([#6928](https://github.com/openemr/openemr/issues/6928))
-  encounters history randomly shows "Patient" in red - round invoice amounts for better comparison and display. ([#6838](https://github.com/openemr/openemr/issues/6838))
-  era posting display floatval fix and typo in patient.inc ([#6675](https://github.com/openemr/openemr/pull/6675))
-  error message on changing table in demographic forms ([#6984](https://github.com/openemr/openemr/issues/6984))
-  expand/collapse of widgets on dashboard summary javascript error when click on the font-awesome icon ([#6993](https://github.com/openemr/openemr/issues/6993))
-  eye form ROS not saving ([#6623](https://github.com/openemr/openemr/issues/6623))
-  eye form lists negative in PMSFH report and side bar even if there are entries ([#6625](https://github.com/openemr/openemr/issues/6625))
-  eye form view.php shorthand icons are position incorrectly in 7.0. ([#6831](https://github.com/openemr/openemr/pull/6831))
-  fix none issue mechanism in the patient summary screen ([#6861](https://github.com/openemr/openemr/pull/6861))
-  fix none mechanism in issues gui ([#6860](https://github.com/openemr/openemr/pull/6860))
-  fix parsing of allergy and medication responses from NewCrop, prevent sending diagnosis other than ICD10 to NewCrop ([#6912](https://github.com/openemr/openemr/pull/6912))
-  fix several clinical_notes form fixes ([#6811](https://github.com/openemr/openemr/pull/6811))
-  fix solar nav background, set default theme if missing in globals, add portal theme to global settings. ([#6536](https://github.com/openemr/openemr/pull/6536))
-  fix static domain included in URL for patient portal onsite documents. ([#6829](https://github.com/openemr/openemr/pull/6829))
-  fix summary screen cards expand and collapse persistence ([#6836](https://github.com/openemr/openemr/pull/6836))
-  flow board stuck on appointment with status CALL ([#6596](https://github.com/openemr/openemr/issues/6596))
-  immunizations are not showing up on the patient summary screen ([#6990](https://github.com/openemr/openemr/issues/6990))
-  insurance date_end field not implemented ([#6532](https://github.com/openemr/openemr/issues/6532))
-  inventory managment datatables warning ([#6642](https://github.com/openemr/openemr/issues/6642))
-  login language selector settings for allowed languages and hiding dummy language ([#7023](https://github.com/openemr/openemr/pull/7023))
-  menu tab with iframe of external domain shows loading overlay even after iframe has loaded ([#6781](https://github.com/openemr/openemr/issues/6781))
-  minor fix in upgrade script for Document_Template_Categories list update ([#6590](https://github.com/openemr/openemr/pull/6590))
-  output X12 payer zip even if not 5 or 9 digits ([#6529](https://github.com/openemr/openemr/issues/6529))
-  output other insco zip ([#6599](https://github.com/openemr/openemr/issues/6599))
-  passing integer instead of referenced variable to genX12837P fatal error ([#6495](https://github.com/openemr/openemr/issues/6495))
-  patient finder + Add New Patient missing webroot ([#6722](https://github.com/openemr/openemr/issues/6722))
-  patient portal card won't render for non-admins ([#6482](https://github.com/openemr/openemr/issues/6482))
-  patient summary screen card sections fix for receptionist ([#6902](https://github.com/openemr/openemr/pull/6902))
-  payment receipt not printing total paid ([#6492](https://github.com/openemr/openemr/issues/6492))
-  posCode not saved with new encounter ([#6871](https://github.com/openemr/openemr/issues/6871))
-  prior auth module hides Report in patient menu for non-admins ([#6578](https://github.com/openemr/openemr/issues/6578))
-  referring provider in X125010837P not looking at the claims referrer ([#6544](https://github.com/openemr/openemr/issues/6544))
-  remove cards max height to prevent scroll on longer lists. ([#7012](https://github.com/openemr/openemr/pull/7012))
-  remove semicolon typos in sql upgrade script for x12_partners table ([#6926](https://github.com/openemr/openemr/pull/6926))
-  reopening and clearing claim fatal error in billing report ([#6614](https://github.com/openemr/openemr/issues/6614))
-  results only electronic procedure results create multiple encounters for same datetime ([#6933](https://github.com/openemr/openemr/issues/6933))
-  service facility zip code not present in 837 professional claims if not 9 digits ([#6488](https://github.com/openemr/openemr/issues/6488))
-  topatient call in billing report doesn't load encs ([#6583](https://github.com/openemr/openemr/issues/6583))
-  typo in 701 to 702 upgrade ([#6586](https://github.com/openemr/openemr/pull/6586))
-  use datetime of procedure result to match existing encounter ([#6934](https://github.com/openemr/openemr/pull/6934))
- quick fix for default open tabs on upgrade ([#6646](https://github.com/openemr/openemr/pull/6646))


### Changed
-  ClaimRev fix styling issue ([#6835](https://github.com/openemr/openemr/pull/6835))
-  Refactor oauth2 authorization flow template files into twig ([#6844](https://github.com/openemr/openemr/issues/6844))
-  change stream to file with mpdf output in billing invoice from recent commit ([#6970](https://github.com/openemr/openemr/pull/6970))
-  fix IDE intellisense error in front_payment.php ([#6898](https://github.com/openemr/openemr/issues/6898))
-  EHI Export - Asynchronous Export Progress Updates. ([#6977](https://github.com/openemr/openemr/pull/6977))
-  use patient filter to assist remote chart review ([#6553](https://github.com/openemr/openemr/issues/6553))
-  Use bootstrap for list items on multi sorted list options ([#6603](https://github.com/openemr/openemr/pull/6603))
-  do not list canceled appts in report by default ([#6547](https://github.com/openemr/openemr/pull/6547))
-  fixes to allergy card in patient summary ([#6863](https://github.com/openemr/openemr/pull/6863))
-  patient summary screen fix for receptionist ([#6862](https://github.com/openemr/openemr/pull/6862))
-  improve button colors in (registration-modal) ([#6804](https://github.com/openemr/openemr/pull/6804))
-  test and refactor populateTimezones function in (ccdaservice) ([#6818](https://github.com/openemr/openemr/pull/6818))


### OpenEMR Developer Changes

### Added
-  API support for _sort parameter ([#6799](https://github.com/openemr/openemr/issues/6799))
-  Add Delete and Render Event Hooks to appointment add screen ([#6591](https://github.com/openemr/openemr/issues/6591))
-  Add OpenEMR regular date time twig filter function ([#6631](https://github.com/openemr/openemr/issues/6631))
-  Add Render event on forms.php page for encounter forms page. ([#6629](https://github.com/openemr/openemr/issues/6629))
-  Add RestAPISecurityCheckEvent to allow module writers to extend or change the API security checks. ([#6504](https://github.com/openemr/openemr/issues/6504))
-  Add a system event to billing payment deletion for module writers to know when a payment is deleted. ([#6841](https://github.com/openemr/openemr/issues/6841))
-  Add core event hooks to QuestionnaireResponse save/insert records. ([#6506](https://github.com/openemr/openemr/issues/6506))
-  Add new environment variable to disable background services for repeater services ([#6601](https://github.com/openemr/openemr/issues/6601))
-  Add system event to send SMS from Secure Messaging for module or core code to hook into ([#6593](https://github.com/openemr/openemr/issues/6593))
-  Add system events for module writers to hook into the CDA Parse Engine ([#6731](https://github.com/openemr/openemr/pull/6731))
-  Add system events to CDA Import for module writers. ([#6715](https://github.com/openemr/openemr/issues/6715))
-  Add system events to be dispatched on the front payments page for module writers. ([#6877](https://github.com/openemr/openemr/issues/6877))
-  Add to UtilsService methods for dealing with FHIR Canonical URLs, OperationOutcomes, and Reference resources ([#6505](https://github.com/openemr/openemr/issues/6505))
-  Allow CORS content-encoding header ([#6634](https://github.com/openemr/openemr/issues/6634))
-  Allow module writers to override / hook into the SMART style_url ([#6919](https://github.com/openemr/openemr/issues/6919))
-  Allow multiple paths to be added to TwigContainer for template directories ([#6632](https://github.com/openemr/openemr/issues/6632))
-  Convert from smarty to twig the SOAP Note  ([#5983](https://github.com/openemr/openemr/issues/5983))
-  Create event to send SMS and Email notifications ([#6588](https://github.com/openemr/openemr/issues/6588))
-  Email Queue support html/text view with twig templates ([#6772](https://github.com/openemr/openemr/issues/6772))
-  Enhance FHIR UtilsService with extension lookup method ([#6849](https://github.com/openemr/openemr/issues/6849))
-  Extend PatientService to have methods for retrieving a list of the PCP for a given list of patients ([#6509](https://github.com/openemr/openemr/issues/6509))
-  Extend appointment dialog with hooks for modules and smart apps ([#6720](https://github.com/openemr/openemr/issues/6720))
-  Extract patient portal pdf generator into separate service ([#6570](https://github.com/openemr/openemr/issues/6570))
-  FHIR Date Search support partial seconds component ([#6669](https://github.com/openemr/openemr/issues/6669))
-  FHIR Patient Resource support generalPractitioner data field ([#6827](https://github.com/openemr/openemr/issues/6827))
-  Fixes #6629 Encounter forms list render event ([#6630](https://github.com/openemr/openemr/pull/6630))
-  Implement Portal Dashboard Audit Report Javascript Event ([#6568](https://github.com/openemr/openemr/issues/6568))
-  Improved customizations on login page logo and portal navbar logo ([#6515](https://github.com/openemr/openemr/pull/6515))
-  Patient Service api sort order for name field make title last field sorted on. ([#6851](https://github.com/openemr/openemr/issues/6851))
-  Patient api endpoints support _lastUpdated search parameter ([#6800](https://github.com/openemr/openemr/issues/6800))
-  Patient portal pdf document return Document object instead of success message ([#6610](https://github.com/openemr/openemr/issues/6610))
-  REST API add user endpoint in order to grab any user not just practitioners. ([#6751](https://github.com/openemr/openemr/issues/6751))
-  Twig extension to get logo from within template, instead of having to pass it in as a variable ([#6247](https://github.com/openemr/openemr/issues/6247))
-  Update FHIR Capability statement to indicate we do not allow resources to be created with an update operation ([#6576](https://github.com/openemr/openemr/issues/6576))
-  add javascript lint support to devtools  ([#6719](https://github.com/openemr/openemr/pull/6719))
-  coverage reports for js unit tests (jest) ([#6735](https://github.com/openemr/openemr/pull/6735))
-  globals setting allow address book data type for user id selection ([#6752](https://github.com/openemr/openemr/issues/6752))
-  minor refactor x12 insurance eligibility api ([#6915](https://github.com/openemr/openemr/pull/6915))


### Fixed
-  API calls with pagination _limit or _offset parameters generates fatal error. ([#6848](https://github.com/openemr/openemr/issues/6848))
-  Allow auth portal users to view pnotes from portal ([#6695](https://github.com/openemr/openemr/issues/6695))
-  Bulk FHIR Export Capability Statement Operation Name incorrect ([#7019](https://github.com/openemr/openemr/issues/7019))
-  Bulk FHIR fails w/ 500 error in patient/system export due to missing patient ids exception ([#7001](https://github.com/openemr/openemr/issues/7001))
-  Bulk Patient FHIR Export fails w/ 500 error when OpenEMR has insurance company provider in the system. ([#7000](https://github.com/openemr/openemr/issues/7000))
-  Duplicate stylelint command in CI ([#6702](https://github.com/openemr/openemr/issues/6702))
-  FHIR Confidential Client fails CORS OPTIONS check in browser window when requesting /token endpoint ([#6497](https://github.com/openemr/openemr/issues/6497))
-  FHIR POST _search operation returns different results than GET search ([#6732](https://github.com/openemr/openemr/issues/6732))
-  FHIR api warnings for missing array keys in AllergyIntolerance, Vitals Observations, Social History Observations, Procedures ([#7002](https://github.com/openemr/openemr/issues/7002))
-  Fix EncounterValidator typo on configureValidator() to avoid fatal error ([#6875](https://github.com/openemr/openemr/issues/6875))
-  Fix QuestionnaireResponse search operation to deal with duplicate field ids in where clause ([#6574](https://github.com/openemr/openemr/issues/6574))
-  Fix fax/sms module event usage from API dispatch.php call ([#6820](https://github.com/openemr/openemr/issues/6820))
-  Fix questionnaire_assessments to not php die if there is a form problem. ([#6677](https://github.com/openemr/openemr/issues/6677))
-  Gulp theme build deprecation warning in development mode ([#6542](https://github.com/openemr/openemr/issues/6542))
-  Missing user rest controller for API causing user api to fail ([#6783](https://github.com/openemr/openemr/issues/6783))
-  Questionnaire URL needs to be a cannonical FQDN url ([#6507](https://github.com/openemr/openemr/issues/6507))
-  Questionnaire source_url breaks if oauth2 fhir url does not end in a slash ([#6672](https://github.com/openemr/openemr/issues/6672))
-  REST API filter by UUID breaks on some endpoints ([#6107](https://github.com/openemr/openemr/pull/6107))
-  Telehealth Patient Updated event signature type broken with patient update by uuid ([#6499](https://github.com/openemr/openemr/issues/6499))
-  Typos in templates/error HTML files ([#6698](https://github.com/openemr/openemr/issues/6698))
-  Unable to use the  internal api and fhir apis locally inside a new module by using the existing code in the test files  ([#6744](https://github.com/openemr/openemr/issues/6744))
-  Zend module installer upgrade broken for custom modules in PHP8 ([#6808](https://github.com/openemr/openemr/issues/6808))
-  add ccdaservice/package-lock.json to .gitignore to help with easy development dockers ([#6979](https://github.com/openemr/openemr/issues/6979))
-  deprecated php: creation of dynamic property $groupId in src/Events/Encounter/EncounterFormsListRenderEvent.php ([#6815](https://github.com/openemr/openemr/issues/6815))
-  escaping in patient portal and transactions screen. ([#6697](https://github.com/openemr/openemr/pull/6697))
-  fix no-mixed-spaces-and-tabs error (eslint) ([#6728](https://github.com/openemr/openemr/pull/6728))
-  lock down pnotes to user ([#6550](https://github.com/openemr/openemr/pull/6550))
-  oauth2 key should regenerate if key is empty or corrupted when in development mode. fix rest config include in api auth controller ([#6607](https://github.com/openemr/openemr/pull/6607))
-  openemr-api.yaml fails validation when generating client library with openapi-generator ([#6967](https://github.com/openemr/openemr/issues/6967))
-  typo in sql upgrade with email_queue table ([#6797](https://github.com/openemr/openemr/issues/6797))
-  use mb_strlen to check field value length in get_layout_form_value() ([#6707](https://github.com/openemr/openemr/pull/6707))


### Changed
-  Change HttpRestRequest class to implement PSR7 ServerRequestInterface ([#6503](https://github.com/openemr/openemr/issues/6503))
-  ESLint setup in OpenEMR ([#6708](https://github.com/openemr/openemr/pull/6708))
-  Improved handling of inserting and updating encounters ([#6647](https://github.com/openemr/openemr/pull/6647))
-  Make it possible to save OAuth2 client outside of AuthorizationController.php ([#6575](https://github.com/openemr/openemr/issues/6575))
-  ci adjustments for alpine 3.18, php 8.2,  and mariadb updates ([#6581](https://github.com/openemr/openemr/pull/6581))
-  ci mariadb stuff - added 11.1 and removed 10.9 ([#6834](https://github.com/openemr/openemr/pull/6834))
-  documentation for flex docker now using alpine 3.18 with php 8.2 ([#6580](https://github.com/openemr/openemr/pull/6580))
-  drop support for arm7 ([#7007](https://github.com/openemr/openemr/pull/7007))
-  insane dev environment updates ([#6925](https://github.com/openemr/openemr/pull/6925))
-  packages update and set min php version 8.1 ([#6867](https://github.com/openemr/openemr/pull/6867))
-  php 8.3 fixes to prepare for next release ([#6935](https://github.com/openemr/openemr/pull/6935))
-  pinned maennchen/zipstream-php version to work with arm7 and updated packages ([#6973](https://github.com/openemr/openemr/pull/6973))
-  specify interface folders with errors (stylelint) ([#6780](https://github.com/openemr/openemr/pull/6780))
-  upgrade phpseclib from version 2 to version 3 ([#6887](https://github.com/openemr/openemr/pull/6887))
-  bugs ([#6552](https://github.com/openemr/openemr/pull/6552))
-  fix AllergyIntoleranceService lookup by pid to return results instead of empty list. ([#6864](https://github.com/openemr/openemr/pull/6864))
-  fix stylelint errors in admin.css (gacl) ([#6777](https://github.com/openemr/openemr/pull/6777))
-  Refactor portal templates scheduling from profile to individual templates in profile ([#6612](https://github.com/openemr/openemr/issues/6612))
-  change the generate_select_list function and incorporate it to Twig ([#6659](https://github.com/openemr/openemr/pull/6659))
-  extract and test cleanCode function (ccdaservice) ([#6785](https://github.com/openemr/openemr/pull/6785))
-  extract and test date functions (ccdaservice) ([#6795](https://github.com/openemr/openemr/pull/6795))
-  extract and test headReplace function (ccdaservice) ([#6792](https://github.com/openemr/openemr/pull/6792))
-  extract and test safeTrim function (ccdaservice) ([#6788](https://github.com/openemr/openemr/pull/6788))
-  improve DataStack class (ccdaservice) ([#6718](https://github.com/openemr/openemr/pull/6718))
-  refactor bucks function with new class based on oeFormatMoney ([#6932](https://github.com/openemr/openemr/pull/6932))
-  test and refactor count entities function (ccdaservice) ([#6805](https://github.com/openemr/openemr/pull/6805))
-  test and refactor fetchPreviousAddresses function in the ccdaservice ([#6828](https://github.com/openemr/openemr/pull/6828))
-  test and refactor populateDemographics function (ccdaservice) ([#6837](https://github.com/openemr/openemr/pull/6837))
