/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.validator;

import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InclusionValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String clazz;
    private final Pattern include;

    public InclusionValidator(String clazz, Pattern include) {
        this.clazz = clazz;
        this.include = include;
    }

    public boolean isIncluded(String name) {
        boolean valid = this.include.matcher(name).matches();
        if (valid) {
            LOGGER.debug("Including {} {}: matches inclusion pattern '{}'", new Object[]{this.clazz, name, this.include});
        } else {
            LOGGER.debug("Excluding {} {}: doesn't match inclusion pattern '{}'", new Object[]{this.clazz, name, this.include});
        }
        return valid;
    }
}

