/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.html.mustache.diagrams;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.schemaspy.output.diagram.RenderException;
import org.schemaspy.output.diagram.Renderer;
import org.schemaspy.output.dot.schemaspy.graph.Graph;
import org.schemaspy.output.html.HtmlException;
import org.schemaspy.output.html.mustache.Diagram;
import org.schemaspy.output.html.mustache.ImgDiagram;
import org.schemaspy.output.html.mustache.SvgDiagram;
import org.schemaspy.util.DefaultPrintWriter;

public class OrphanDiagram
implements Diagram {
    private static final String NAME = "orphans";
    private final Graph graph;
    private final Renderer renderer;
    private final Path outputDir;

    public OrphanDiagram(Graph graph, Renderer renderer, File outputDir) {
        this.graph = graph;
        this.renderer = renderer;
        this.outputDir = outputDir.toPath().resolve("diagrams").resolve(NAME);
    }

    public String html() {
        this.outputDir.toFile().mkdirs();
        return this.writeDiagram(this.writeDot()).html();
    }

    private Path writeDot() {
        Path dotFile = this.outputDir.resolve(this.fileName("dot"));
        try (DefaultPrintWriter dotOut = new DefaultPrintWriter(dotFile.toFile());){
            dotOut.println(this.graph.dot());
            dotOut.flush();
        }
        catch (IOException e) {
            throw new HtmlException("Failed to write dot: " + dotFile, (Throwable)e);
        }
        return dotFile;
    }

    private Diagram writeDiagram(Path dotFile) {
        try {
            Path diagramFile = this.outputDir.resolve(this.fileName(this.renderer.format()));
            String diagramMap = this.renderer.render(dotFile.toFile(), diagramFile.toFile());
            String diagramSource = "diagrams/orphans/" + diagramFile.getFileName().toString();
            if ("svg".equalsIgnoreCase(this.renderer.format())) {
                return new SvgDiagram(NAME, diagramSource);
            }
            return new ImgDiagram(NAME, diagramSource, diagramMap);
        }
        catch (RenderException renderException) {
            throw new HtmlException("Failed to generate Orphan diagram", (Throwable)renderException);
        }
    }

    private String fileName(String extension) {
        return "orphans." + extension;
    }
}

