/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram;

import java.io.File;
import org.schemaspy.output.diagram.DiagramResult;
import org.schemaspy.output.diagram.RenderException;
import org.schemaspy.output.diagram.Renderer;

public class SummaryDiagram {
    private final Renderer renderer;
    private final File summaryDir;

    public SummaryDiagram(Renderer renderer, File summaryDir) {
        this.renderer = renderer;
        this.summaryDir = summaryDir;
    }

    public DiagramResult generateSummaryDiagram(File dotFile, String diagramName) {
        try {
            File diagramFile = new File(this.summaryDir, diagramName + "." + this.renderer.format());
            String diagramMap = this.renderer.render(dotFile, diagramFile);
            return new DiagramResult(diagramFile.getName(), diagramMap, this.renderer.format());
        }
        catch (RenderException diagramException) {
            throw new RenderException("Failed to generate summary diagram", (Throwable)diagramException);
        }
    }
}

