/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.driverclass;

import java.sql.Driver;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.schemaspy.input.dbms.driverclass.DcClassloader;
import org.schemaspy.input.dbms.driverclass.DcErrorLogged;
import org.schemaspy.input.dbms.driverclass.DcIterator;
import org.schemaspy.input.dbms.driverclass.Driverclass;
import org.schemaspy.input.dbms.exceptions.ConnectionFailure;

public class DcFacade
implements Driverclass {
    private final String[] driverClasses;
    private final ClassLoader loader;
    private final String message;

    public DcFacade(String[] driverClasses, ClassLoader loader, String message) {
        this.driverClasses = driverClasses;
        this.loader = loader;
        this.message = message;
    }

    public Class<Driver> value() {
        List candidates = Arrays.stream(this.driverClasses).map(candidate -> new DcErrorLogged((Driverclass)new DcClassloader(candidate, this.loader))).collect(Collectors.toList());
        try {
            return new DcIterator(candidates.iterator()).value();
        }
        catch (NoSuchElementException e) {
            throw new ConnectionFailure(this.message);
        }
    }
}

