/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.schemaspy.connection.Connection;
import org.schemaspy.connection.PreferencesConnection;
import org.schemaspy.connection.WithPassword;
import org.schemaspy.connection.WithUser;
import org.schemaspy.input.dbms.ConnectionConfig;
import org.schemaspy.input.dbms.ConnectionURLBuilder;
import org.schemaspy.input.dbms.DbDriverLoaderErrorMessage;
import org.schemaspy.input.dbms.classloader.ClDefault;
import org.schemaspy.input.dbms.classpath.Classpath;
import org.schemaspy.input.dbms.classpath.GetExistingUrls;
import org.schemaspy.input.dbms.classpath.LoadAdditionalJarsForDriver;
import org.schemaspy.input.dbms.classpath.WithSiblings;
import org.schemaspy.input.dbms.driver.DsDriverClass;
import org.schemaspy.input.dbms.driverclass.DcFacade;
import org.schemaspy.input.dbms.driverpath.DpConnectionConfig;
import org.schemaspy.input.dbms.driverpath.DpFallback;
import org.schemaspy.input.dbms.driverpath.DpNull;
import org.schemaspy.input.dbms.driverpath.DpProperties;
import org.schemaspy.input.dbms.driverpath.Driverpath;
import org.schemaspy.input.dbms.exceptions.ConnectionFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbDriverLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<String, Driver> driverCache = new HashMap();
    private final ConnectionConfig connectionConfig;
    private final ConnectionURLBuilder urlBuilder;
    private final String[] driverClass;
    private Driverpath driverPath;

    public DbDriverLoader(ConnectionConfig connectionConfig) {
        this(connectionConfig, new ConnectionURLBuilder(connectionConfig));
    }

    public DbDriverLoader(ConnectionConfig connectionConfig, ConnectionURLBuilder urlBuilder) {
        this(connectionConfig, urlBuilder, connectionConfig.getDatabaseTypeProperties());
    }

    public DbDriverLoader(ConnectionConfig connectionConfig, ConnectionURLBuilder urlBuilder, Properties properties) {
        this(connectionConfig, urlBuilder, properties.getProperty("driver").split(","), (Driverpath)new DpFallback((Driverpath)new DpConnectionConfig(connectionConfig), (Driverpath)new DpFallback((Driverpath)new DpProperties(properties), (Driverpath)new DpNull())));
    }

    public DbDriverLoader(ConnectionConfig connectionConfig, ConnectionURLBuilder urlBuilder, String[] driverClass, Driverpath driverPath) {
        this.connectionConfig = connectionConfig;
        this.urlBuilder = urlBuilder;
        this.driverClass = driverClass;
        this.driverPath = driverPath;
    }

    public java.sql.Connection getConnection() throws IOException {
        java.sql.Connection connection;
        String connectionURL = this.urlBuilder.build();
        CharSequence[] driverClasses = this.driverClass;
        Properties connectionProperties = new WithPassword(this.connectionConfig.getPassword(), (Connection)new WithUser(this.connectionConfig.getUser(), (Connection)new PreferencesConnection(this.connectionConfig.getConnectionProperties()))).properties();
        try {
            Driver driver = this.getDriver();
            connection = driver.connect(connectionURL, connectionProperties);
            if (connection == null) {
                throw new ConnectionFailure("Cannot connect to '" + connectionURL + "' with driver '" + String.join((CharSequence)",", driverClasses) + "'");
            }
        }
        catch (UnsatisfiedLinkError badPath) {
            throw new ConnectionFailure("Error with native library occurred while trying to use driver '" + String.join((CharSequence)",", driverClasses) + "'", (Throwable)badPath);
        }
        catch (Exception exc) {
            throw new ConnectionFailure("Failed to connect to database URL [" + connectionURL + "]", (Throwable)exc);
        }
        return connection;
    }

    protected synchronized Driver getDriver() {
        Driver driver;
        String[] driverClasses = this.driverClass;
        String driverPath = this.driverPath.value();
        for (String string : driverClasses) {
            driver = (Driver)driverCache.get(string + "|" + driverPath);
            if (!Objects.nonNull(driver)) continue;
            return driver;
        }
        Set classpath = new WithSiblings(this.connectionConfig, (Classpath)new GetExistingUrls(driverPath), (Classpath)new LoadAdditionalJarsForDriver(driverPath)).paths();
        List<URL> urls = classpath.stream().map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[classpath.size()]), new ClDefault().classloader());
        Class clazz = new DcFacade(driverClasses, (ClassLoader)loader, new DbDriverLoaderErrorMessage(driverClasses, driverPath, classpath, this.connectionConfig).createMessage()).value();
        driver = new DsDriverClass(clazz, new DbDriverLoaderErrorMessage(driverClasses, driverPath, classpath, this.connectionConfig).createMessage()).driver();
        driverCache.put(clazz.getName() + "|" + driverPath, driver);
        return driver;
    }
}

