/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.schemaspy.InsertionOrdered;
import org.schemaspy.model.Database;
import org.schemaspy.model.ForeignKeyConstraint;
import org.schemaspy.model.Table;

public class InsertionOrdered {
    private final Collection<Table> tables;

    public InsertionOrdered(Database db) {
        this(db.getTables());
    }

    public InsertionOrdered(Collection<Table> tables) {
        this.tables = tables;
    }

    public List<Table> getTablesOrderedByRI() {
        ArrayList heads = new ArrayList();
        ArrayList tails = new ArrayList();
        ArrayList remainingTables = new ArrayList(this.tables);
        this.removeRemotes(remainingTables);
        List floaters = this.floaters(remainingTables);
        remainingTables.removeAll(floaters);
        List unattached = this.sortTrimmedLevel(floaters);
        while (!remainingTables.isEmpty() && !this.hasRecursion(remainingTables)) {
            tails.addAll(0, this.trimLeaves(remainingTables));
            heads.addAll(this.trimRoots(remainingTables));
        }
        if (this.hasRecursion(remainingTables)) {
            for (Table table : remainingTables) {
                table.removeNonRealForeignKeys();
            }
        }
        while (!remainingTables.isEmpty()) {
            boolean foundSimpleRecursion;
            boolean hasRecursion = this.hasRecursion(remainingTables);
            tails.addAll(0, this.trimLeaves(remainingTables));
            heads.addAll(this.trimRoots(remainingTables));
            if (!hasRecursion || (foundSimpleRecursion = this.removeSelfReferencingConstraints(remainingTables))) continue;
            this.removeAForeignKeyConstraint(remainingTables);
        }
        ArrayList<Table> ordered = new ArrayList<Table>(heads.size() + tails.size());
        ordered.addAll(heads);
        ordered.addAll(tails);
        ordered.addAll(unattached);
        return ordered;
    }

    private boolean hasRecursion(List<Table> remainingTables) {
        LinkedList<Table> copy = new LinkedList<Table>(remainingTables);
        copy.removeIf(Table::isLeaf);
        copy.removeIf(Table::isRoot);
        return copy.size() == remainingTables.size();
    }

    private void removeRemotes(List<Table> remainingTables) {
        remainingTables.stream().filter(Table::isRemote).forEach(table -> {
            table.unlinkParents();
            table.unlinkChildren();
        });
        remainingTables.removeIf(Table::isRemote);
    }

    private List<Table> floaters(List<Table> remainingTables) {
        return remainingTables.stream().filter(Table::isFloater).collect(Collectors.toList());
    }

    private List<Table> trimLeaves(List<Table> tables) {
        ArrayList<Table> leaves = new ArrayList<Table>();
        for (Table leaf : tables) {
            if (!leaf.isLeaf()) continue;
            leaves.add(leaf);
        }
        tables.removeAll(leaves);
        List trimmedLeaves = this.sortTrimmedLevel(leaves);
        for (Table trimmedLeaf : trimmedLeaves) {
            trimmedLeaf.unlinkParents();
        }
        return trimmedLeaves;
    }

    private List<Table> trimRoots(List<Table> tables) {
        ArrayList<Table> roots = new ArrayList<Table>();
        for (Table root : tables) {
            if (!root.isRoot()) continue;
            roots.add(root);
        }
        tables.removeAll(roots);
        List trimmedRoots = this.sortTrimmedLevel(roots);
        for (Table trimmedRoot : trimmedRoots) {
            trimmedRoot.unlinkChildren();
        }
        return trimmedRoots;
    }

    private List<Table> sortTrimmedLevel(List<Table> tables) {
        TreeSet<Table> sorter = new TreeSet<Table>((Comparator<Table>)new TrimComparator(this));
        sorter.addAll(tables);
        return new ArrayList<Table>(sorter);
    }

    private boolean removeSelfReferencingConstraints(List<Table> remainingTables) {
        for (Table potentialRecursiveTable : remainingTables) {
            ForeignKeyConstraint recursiveConstraint = potentialRecursiveTable.removeSelfReferencingConstraint();
            if (recursiveConstraint == null) continue;
            return true;
        }
        return false;
    }

    private void removeAForeignKeyConstraint(List<Table> remainingTables) {
        remainingTables.stream().min((t1, t2) -> {
            int rc = Math.abs(t2.getNumChildren() - t2.getNumParents()) - Math.abs(t1.getNumChildren() - t1.getNumParents());
            if (rc == 0) {
                rc = t1.compareTo(t2);
            }
            return rc;
        }).ifPresent(Table::removeAForeignKeyConstraint);
    }
}

